/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDFContext;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSecurityData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;

public class TaxStatementSSKLegend
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_LEGEND";
    public static final String HEADER_EXTENDED = "HEADER_LEGEND_EXTENDED";
    public static final String LEGEND_ = "LEGEND_";
    public static final String DESCRIPTION_LINE1 = "LEGEND_DESCRIPTION_LINE1";
    public static final String DESCRIPTION_LINE2 = "LEGEND_DESCRIPTION_LINE2";
    public static final String DESCRIPTION_LINE3 = "LEGEND_DESCRIPTION_LINE3";
    public static final String NUMBER_LINE1 = "LEGEND_NUMBER_LINE1";
    public static final String NUMBER_LINE2 = "LEGEND_NUMBER_LINE2";
    public static final String NUMBER_LINE3 = "LEGEND_NUMBER_LINE3";
    public static final int COL1 = 71;
    public static final int COL2 = 120;
    public static final int NMAX = 160;

    protected int col1() {
        return 71 + this.offsetX();
    }

    protected int col2() {
        return 120 + this.offsetX();
    }

    protected int nmax() {
        return 160;
    }

    protected PDPage addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        this.endPage(ct, pdd, font, bold, doc, lang, data);
        PDPage page = new PDPage();
        page.setMediaBox(PDRectangle.A4);
        page.setRotation(90);
        pdd.addPage(page);
        ct.setPage(page).setRow(0);
        if (layout != null) {
            layout.addLayout(pdd, font, bold, logo, size, doc, lang, data, content, page, this.extended() ? HEADER_EXTENDED : HEADER);
            layout.addPageBarCode(pdd, font, bold, doc, page, 197);
        }
        return page;
    }

    protected PDPageContentStream addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx) throws IOException, ParseException, XPathExpressionException {
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
        PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
        cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        cs.transform(mx);
        return cs;
    }

    protected void endPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data) throws IOException, ParseException, XPathExpressionException {
        if (ct.getPage() != null) {
            this.addHeader(ct, pdd, font, bold, doc, lang, data, ct.getPage());
        }
    }

    protected void addHeader(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page) throws IOException, ParseException, XPathExpressionException {
        PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
        Color grey = new Color(211, 211, 211);
        cs.transform(mx);
        int yh = this.yh();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int row1 = yh + 2 - 10;
        int row2 = yh + 2 - 20;
        int row3 = yh + 2 - 30;
        TaxStatementPDFUtil.drawRectangle(cs, grey, xa, yh, xe, row3 - 4, grey);
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row1, TaxStatementPDFUtil.getText(lang, NUMBER_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row2, TaxStatementPDFUtil.getText(lang, NUMBER_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, row3, TaxStatementPDFUtil.getText(lang, NUMBER_LINE3));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row1, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE1));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row2, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE2));
        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, row3, TaxStatementPDFUtil.getText(lang, DESCRIPTION_LINE3));
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
    }

    protected PDPageContentStream addLegend(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String legend) throws IOException, ParseException, XPathExpressionException {
        int row = ct.getRow();
        if (row > 0 && ++row > this.rows()) {
            cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
            row = 0;
        }
        String name = TaxStatementPDFUtil.getText(lang, LEGEND_ + legend.replace("(", "").replace(")", ""));
        String name1 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 1));
        String name2 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 2));
        String name3 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 3));
        String name4 = TaxStatementPDFUtil.trim(TaxStatementPDFUtil.split(name, this.nmax(), 4));
        int ya = this.ya();
        int col1 = this.col1();
        int col2 = this.col2();
        if (legend != null) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - row * 10, legend.equals("NA") ? TaxStatementPDFUtil.getText(lang, "SECURITY_TAX_VALUE_NA") : legend);
        }
        if (name1 != null && name1.length() > 0) {
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name2);
        }
        if (name3 != null && name3.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name3);
        }
        if (name4 != null && name4.length() > 0) {
            if (++row > this.rmax()) {
                cs = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx);
                row = 0;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, name4);
        }
        ct.setRow(++row);
        return cs;
    }

    protected void addLegend(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        ArrayList<String> legends = new ArrayList<String>();
        int depots = TaxStatementPDFSecurityData.getDepotCount(doc);
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementPDFSecurityData.getSecurityCount(doc, depot);
            for (int security = 1; security <= securities; ++security) {
                Double quantity = TaxStatementPDFSecurityData.getTaxValueQuantity(doc, depot, security);
                Boolean undefined = TaxStatementPDFSecurityData.getTaxValueUndefined(doc, depot, security);
                if (undefined != null && undefined.booleanValue() && quantity != null && quantity != 0.0 && !legends.contains("NA")) {
                    legends.add("NA");
                }
                int payments = TaxStatementPDFSecurityData.getPaymentCount(doc, depot, security);
                for (int payment = 1; payment <= payments; ++payment) {
                    Boolean iup = TaxStatementPDFSecurityData.getPaymentIUP(doc, depot, security, payment);
                    String sign = TaxStatementPDFSecurityData.getPaymentSign(doc, depot, security, payment);
                    if (sign != null && sign.length() > 0) {
                        sign = sign.replace("(", "").replace(")", "");
                    }
                    if (sign != null && sign.length() < 3) {
                        sign = "(" + sign + ")";
                    }
                    if (iup != null && iup.booleanValue() && !legends.contains("IUP")) {
                        legends.add("IUP");
                    }
                    if (sign == null || sign.length() <= 0 || legends.contains(sign)) continue;
                    legends.add(sign);
                }
                Boolean iup = TaxStatementPDFSecurityData.getSecurityIUP(doc, depot, security);
                if (iup == null || !iup.booleanValue() || legends.contains("IUP")) continue;
                legends.add("IUP");
            }
        }
        Collections.sort(legends);
        if (legends != null && !legends.isEmpty()) {
            TaxStatementPDFContext ct = new TaxStatementPDFContext();
            PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
            PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
            Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
            cs.transform(mx);
            for (String legend : legends) {
                cs = this.addLegend(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, cs, mx, legend);
            }
            cs.transform(mx);
            cs.transform(mx);
            cs.transform(mx);
            cs.close();
            this.endPage(ct, pdd, font, bold, doc, lang, data);
        }
    }
}

