/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFText;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.w3c.dom.Document;

public class TaxStatementSSKLetter
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_LETTER";
    public static final String HEADER_EXTENDED = "HEADER_LETTER_EXTENDED";

    protected void addLetter(PDDocument pdd, PDPage page, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        if (pdd != null && page != null && layout != null) {
            PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
            layout.addContent(pdd, lang, data, content, this.extended() ? HEADER_EXTENDED : HEADER);
            layout.addSSK(pdd, font, bold, doc, lang, data, page, cs);
            layout.addLogo(pdd, font, bold, logo, size, doc, lang, data, page, cs);
            layout.addClient(pdd, font, bold, doc, lang, data, page, cs);
            layout.addFooter(pdd, font, bold, doc, lang, data, page, cs);
            cs.close();
            layout.addPageBarCode(pdd, font, bold, doc, page, 197, this.landscape(page));
        }
    }

    public void addLetter(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDDocument letter) throws IOException, ParseException, XPathExpressionException {
        if (letter != null) {
            int px = 0;
            for (PDPage p : letter.getPages()) {
                TaxStatementPDFText tt = new TaxStatementPDFText(letter, ++px);
                PDPage page = null;
                page = tt.containsPlaceholder() ? tt.importPage(pdd, p, font, bold, data) : pdd.importPage(p);
                this.addLetter(pdd, page, font, bold, layout, logo, size, doc, lang, data, content);
                this.addDot();
            }
        }
    }
}

