/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.TaxStatement;
import ch.ewv.taxstatement.report.TaxStatementReportCaseList;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultContent;
import ch.ewv.taxstatement.report.TaxStatementReportResultList;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class TaxStatementReport {
    private String source;
    private TaxStatementReportResultList resultList;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public TaxStatementReportResultList getResultList() {
        return this.resultList;
    }

    protected void setResultList(TaxStatementReportResultList resultList) {
        this.resultList = resultList;
    }

    public List<String> content() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID;NAME;RESULT");
        if (this.getResultList() != null && this.getResultList().getContent() != null) {
            for (TaxStatementReportResultContent entry : this.getResultList().getContent()) {
                if (entry == null) continue;
                list.add(entry.getId() + ";" + entry.getName() + ";" + (entry.getResult() == TaxStatementReportResult.OK ? "1" : "0"));
            }
        }
        return list;
    }

    public TaxStatementReportResultList execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return new TaxStatementReportCaseList().execute(doc, xml, lang, formula);
    }

    public Properties language() throws IOException {
        return TaxStatementReportUtil.getLanguage(TaxStatementReportProperty.LANG);
    }

    public Properties language(String language) throws IOException {
        return TaxStatementReportUtil.getLanguage(language);
    }

    protected byte[] load(String name) throws IOException {
        File file = new File(name);
        if (!file.exists() || file.isDirectory()) {
            System.out.println("File " + name + " not found!");
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] xml = new byte[(int)file.length()];
        fis.read(xml, 0, xml.length);
        fis.close();
        return xml;
    }

    public byte[] load(String[] args) throws IOException {
        String name = args.length > 0 ? args[0] : null;
        this.setSource(name);
        if (name != null) {
            name = name.replace(".PDF", ".pdf").replace(".pdf", ".xml");
        }
        return this.load(name);
    }

    protected abstract void save(String var1) throws IOException;

    public void save(String[] args) throws IOException {
        String name = new String(args.length > 1 ? (!args[1].endsWith(TaxStatementReportProperty.FILE_SEPARATOR) ? args[1] : (!args[0].contains(TaxStatementReportProperty.FILE_SEPARATOR) ? args[1] + args[0] : args[1] + args[0].substring(args[0].lastIndexOf(TaxStatementReportProperty.FILE_SEPARATOR) + 1))) : args[0]);
        if (name != null) {
            name = name.replace(".CSV", ".csv").replace(".PDF", ".pdf").replace(".XLSX", ".xlsx").replace(".XML", ".xml").replace(";", "");
        }
        this.save(name);
    }

    protected abstract void translate(Document var1, byte[] var2, Properties var3, TaxStatementReportFormula var4, TaxStatementReportResultList var5) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException;

    public void translate(byte[] xml) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.translate(xml, TaxStatementReportProperty.LANG);
    }

    public void translate(byte[] xml, String language) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream bis = new ByteArrayInputStream(xml);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        Document doc = dbf.newDocumentBuilder().parse(bis);
        TaxStatementReportFormula formula = new TaxStatementReportFormula(doc);
        Properties lang = this.language(language);
        this.setResultList(this.execute(doc, xml, lang, formula));
        this.translate(doc, xml, lang, formula, this.getResultList());
    }

    public void translate(PDDocument pdd) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.translate(TaxStatement.extractXML(pdd));
    }

    public void translate(PDDocument pdd, String language) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.translate(TaxStatement.extractXML(pdd), language);
    }

    public void translate(String[] args) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        byte[] xml = this.load(args);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream bis = new ByteArrayInputStream(xml);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        Document doc = dbf.newDocumentBuilder().parse(bis);
        TaxStatementReportFormula formula = new TaxStatementReportFormula(doc);
        Properties lang = this.language();
        this.setResultList(this.execute(doc, xml, lang, formula));
        this.translate(doc, xml, lang, formula, this.getResultList());
        this.save(args);
    }
}

