/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportBankAccountData;
import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportBankAccountCase02
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportBankAccountData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportBankAccountData.getBankAccountCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                Date referenceDate = TaxStatementReportBankAccountData.getTaxValueReferenceDate(doc, i, j);
                if (referenceDate != null) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                String name = TaxStatementReportBankAccountData.getTaxValueName(doc, i, j);
                if (name != null) {
                    if (name.length() >= 1 && name.length() <= 200) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + name);
                    } else if (name.length() > 200) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + account + ") " + name.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 200");
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + name);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                String currency = TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc, i, j);
                if (currency != null) {
                    if (currency.length() == 3 && currency.charAt(0) >= 'A' && currency.charAt(0) <= 'Z' && currency.charAt(1) >= 'A' && currency.charAt(1) <= 'Z' && currency.charAt(2) >= 'A' && currency.charAt(2) <= 'Z') {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + currency);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + currency);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                String currency = TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc, i, j);
                Double balance = TaxStatementReportBankAccountData.getTaxValueBalance(doc, i, j);
                Double value = TaxStatementReportBankAccountData.getTaxValueValue(doc, i, j);
                if (currency != null && !currency.equals("CHF") && balance != null && balance >= 0.0) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", balance));
                } else if (currency != null && !currency.equals("CHF") && balance != null && balance < 0.0) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", balance));
                } else if (currency != null && !currency.equals("CHF") && balance == null && value != null && value == 0.0) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", balance));
                } else if (currency != null && currency.equals("CHF") && balance != null && balance >= 0.0) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", balance));
                } else if (currency != null && currency.equals("CHF") && balance != null && balance < 0.0) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", balance));
                } else if (currency != null && currency.equals("CHF") && balance == null) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", balance));
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                String currency = TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc, i, j);
                Double balance = TaxStatementReportBankAccountData.getTaxValueBalance(doc, i, j);
                Double exchangeRate = TaxStatementReportBankAccountData.getTaxValueExchangeRate(doc, i, j);
                if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + currency);
                } else if (currency != null && !currency.equals("CHF") && balance != null && balance == 0.0 && exchangeRate == null) {
                    entity.setResult(TaxStatementReportResult.IGNORE);
                } else if (currency != null && !currency.equals("CHF") && balance != null && exchangeRate == null) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + currency);
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                String currency = TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc, i, j);
                Double exchangeRate = TaxStatementReportBankAccountData.getTaxValueExchangeRate(doc, i, j);
                if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                    entity.setResult(TaxStatementReportResult.SELECT);
                } else if (currency != null && currency.equals("CHF")) {
                    entity.setResult(TaxStatementReportResult.IGNORE);
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                String currency = TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc, i, j);
                Double balance = TaxStatementReportBankAccountData.getTaxValueBalance(doc, i, j);
                Double exchangeRate = TaxStatementReportBankAccountData.getTaxValueExchangeRate(doc, i, j);
                Double value = TaxStatementReportBankAccountData.getTaxValueValue(doc, i, j);
                if (value != null && value >= 0.0) {
                    if (currency != null && currency.equals("CHF") && balance != null && String.format("%1$,.2f", value).equals(String.format("%1$,.2f", balance))) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", value));
                    } else if (currency != null && currency.equals("CHF") && balance != null && TaxStatementReportUtil.approximately(value, balance, 0.0499999999).booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && formula.approximately(value, balance).booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", balance));
                    } else if (currency != null && currency.equals("CHF") && balance != null && !String.format("%1$,.2f", value).equals(String.format("%1$,.2f", balance))) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && exchangeRate != null && value == 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && value == 0.0) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", value));
                    }
                } else if (value != null && value < 0.0) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", value));
                } else if (currency != null && currency.equals("CHF") && balance != null && balance > 0.0) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance));
                } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0 && exchangeRate != null) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + String.format("%1$,.5f", exchangeRate));
                } else if (currency != null && !currency.equals("CHF") && balance != null && balance > 0.0) {
                    if (TaxStatementReportProperty.EXCHANGE_RATE) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10));
        int i = 1;
        int account = 1;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        while (i <= accounts) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues; ++j) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportBankAccountData.getBankAccountName(doc, i));
                String currency = TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc, i, j);
                Double balance = TaxStatementReportBankAccountData.getTaxValueBalance(doc, i, j);
                Double exchangeRate = TaxStatementReportBankAccountData.getTaxValueExchangeRate(doc, i, j);
                Double value = TaxStatementReportBankAccountData.getTaxValueValue(doc, i, j);
                Double valueCalc = null;
                if (currency != null && !currency.equals("CHF") && balance != null && exchangeRate != null) {
                    valueCalc = balance * exchangeRate;
                }
                if (currency != null && !currency.equals("CHF")) {
                    if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + account + ") " + String.format("%1$,.2f", value));
                    } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                    } else if (formula.approximately(value, valueCalc).booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                    } else if (value != null && valueCalc == null && value == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + account + ") " + String.format("%1$,.2f", value));
                    } else if (balance != null && balance == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && valueCalc != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                    } else if (balance != null && balance > 0.0) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + account + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", balance) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                } else {
                    entity.setResult(TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
            }
            ++i;
            ++account;
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, null}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportBankAccountData.getTotalTaxValue(doc) != null && TaxStatementReportBankAccountData.getBankAccountCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueName(doc) && TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0 && TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc)));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0 && TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc) && TaxStatementReportBankAccountData.getTaxValueBalance(doc)));
        cs.addStepResultOptional(ok[8], this.execute08(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0 && TaxStatementReportBankAccountData.getTaxValueExchangeRate(doc)));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[10], this.execute10(doc, lang, formula, TaxStatementReportBankAccountData.getTaxValueCount(doc) > 0 && TaxStatementReportBankAccountData.getTaxValueBalance(doc)));
        return cs;
    }

    public TaxStatementReportBankAccountCase02() {
        super("BANK_ACCOUNT_CASE", 2);
    }
}

