/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.text.ParseException;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementReportExpenseData {
    public static Double getTotalExpenses(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpenses");
    }

    public static Double getTotalExpensesDeductible(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpensesDeductible");
    }

    public static Double getTotalExpensesDeductibleCanton(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpensesDeductibleCanton");
    }

    public static int getExpenseCount(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfExpenses/expense)");
    }

    public static String getExpenseAccountNumber(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@bankAccountNumber");
    }

    public static boolean getExpenseAmount(Document doc) throws XPathExpressionException {
        boolean value = true;
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && value; ++i) {
            Double amount = TaxStatementReportExpenseData.getExpenseAmount(doc, i);
            if (amount != null) continue;
            value = false;
        }
        return value;
    }

    public static Double getExpenseAmount(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@amount");
    }

    public static boolean getExpenseAmountCurrency(Document doc) throws XPathExpressionException {
        boolean value = true;
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && value; ++i) {
            String currency = TaxStatementReportExpenseData.getExpenseAmountCurrency(doc, i);
            if (currency == null || !currency.equals("CHF")) continue;
            value = false;
        }
        return value;
    }

    public static String getExpenseAmountCurrency(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@amountCurrency");
    }

    public static String getExpenseDepotNumber(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@depotNumber");
    }

    public static boolean getExpenseExchangeRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && value; ++i) {
            Double exchangeRate = TaxStatementReportExpenseData.getExpenseExchangeRate(doc, i);
            if (exchangeRate != null) continue;
            value = false;
        }
        return value;
    }

    public static Double getExpenseExchangeRate(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@exchangeRate");
    }

    public static Double getExpenseExpenses(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expenses");
    }

    public static String getExpenseIBAN(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@iban");
    }

    public static String getExpenseName(Document doc, int expense) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@name");
    }

    public static boolean getExpenseReferenceDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int expenses = TaxStatementReportExpenseData.getExpenseCount(doc);
        for (int i = 1; i <= expenses && value; ++i) {
            Date referenceDate = TaxStatementReportExpenseData.getExpenseReferenceDate(doc, i);
            if (referenceDate != null) continue;
            value = false;
        }
        return value;
    }

    public static Date getExpenseReferenceDate(Document doc, int expense) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@referenceDate");
    }

    public static Integer getExpenseType(Document doc, int expense) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueInteger(doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expenseType");
    }
}

