/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.text.ParseException;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementReportFormula {
    private Document doc;
    private Double totalBankAccountTaxValue = Double.NaN;
    private Double totalBankAccountGrossRevenueA = Double.NaN;
    private Double totalBankAccountGrossRevenueB = Double.NaN;
    private Double totalBankAccountWithHoldingTaxClaim = Double.NaN;
    private Double totalExpenses = Double.NaN;
    private Double totalExpensesDeductible = Double.NaN;
    private Double totalExpensesDeductibleCanton = Double.NaN;
    private Double totalLiabilityAccountTaxValue = Double.NaN;
    private Double totalLiabilityAccountGrossRevenueB = Double.NaN;
    private Double totalSecurityTaxValue = Double.NaN;
    private Double totalSecurityTaxValueOther = Double.NaN;
    private Double totalSecurityGrossRevenueA = Double.NaN;
    private Double totalSecurityGrossRevenueACanton = Double.NaN;
    private Double totalSecurityGrossRevenueAIUPPositive = Double.NaN;
    private Double totalSecurityGrossRevenueAIUPNegative = Double.NaN;
    private Double totalSecurityGrossRevenueB = Double.NaN;
    private Double totalSecurityGrossRevenueBCanton = Double.NaN;
    private Double totalSecurityGrossRevenueBIUPPositive = Double.NaN;
    private Double totalSecurityGrossRevenueBIUPNegative = Double.NaN;
    private Double totalSecurityGrossRevenueBRetrocession = Double.NaN;
    private Double totalSecurityGrossRevenueBSecuritiesLending = Double.NaN;
    private Double totalSecurityGrossRevenueConversion = Double.NaN;
    private Double totalSecurityGrossRevenueIUP = Double.NaN;
    private Double totalSecurityGrossRevenueIUPNet = Double.NaN;
    private Double totalSecurityWithHoldingTaxClaim = Double.NaN;
    private Double totalSecurityLumpSumTaxCredit = Double.NaN;
    private Double totalSecurityNonRecoverableTax = Double.NaN;
    private Double totalSecurityAdditionalWithHoldingTaxUSA = Double.NaN;
    private Double totalTaxValue = Double.NaN;
    private Double totalGrossRevenueA = Double.NaN;
    private Double totalGrossRevenueACanton = Double.NaN;
    private Double totalGrossRevenueB = Double.NaN;
    private Double totalGrossRevenueBCanton = Double.NaN;
    private Double totalWithHoldingTaxClaim = Double.NaN;
    private Boolean exDate = null;
    private Boolean ignoreDigits = null;
    private Boolean withHoldingTax = null;

    public Double calcTotalBankAccountTaxValue() throws XPathExpressionException {
        if (this.totalBankAccountTaxValue != null && this.totalBankAccountTaxValue.isNaN()) {
            this.totalBankAccountTaxValue = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount/@totalTaxValue)"));
        }
        return this.totalBankAccountTaxValue;
    }

    public Double calcTotalBankAccountTaxValue(int element) throws XPathExpressionException {
        return TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount[" + element + "]/@totalTaxValue)"));
    }

    public Double calcTotalBankAccountGrossRevenueA() throws XPathExpressionException {
        if (this.totalBankAccountGrossRevenueA != null && this.totalBankAccountGrossRevenueA.isNaN()) {
            this.totalBankAccountGrossRevenueA = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount/@totalGrossRevenueA)"));
        }
        return this.totalBankAccountGrossRevenueA;
    }

    public Double calcTotalBankAccountGrossRevenueA(int element) throws XPathExpressionException {
        return TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount[" + element + "]/@totalGrossRevenueA)"));
    }

    public Double calcTotalBankAccountGrossRevenueB() throws XPathExpressionException {
        if (this.totalBankAccountGrossRevenueB != null && this.totalBankAccountGrossRevenueB.isNaN()) {
            this.totalBankAccountGrossRevenueB = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount/@totalGrossRevenueB)"));
        }
        return this.totalBankAccountGrossRevenueB;
    }

    public Double calcTotalBankAccountGrossRevenueB(int element) throws XPathExpressionException {
        return TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount[" + element + "]/@totalGrossRevenueB)"));
    }

    public Double calcTotalBankAccountWithHoldingTaxClaim() throws XPathExpressionException {
        if (this.totalBankAccountWithHoldingTaxClaim != null && this.totalBankAccountWithHoldingTaxClaim.isNaN()) {
            this.totalBankAccountWithHoldingTaxClaim = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount/@totalWithHoldingTaxClaim)"));
        }
        return this.totalBankAccountWithHoldingTaxClaim;
    }

    public Double calcTotalBankAccountWithHoldingTaxClaim(int element) throws XPathExpressionException {
        return TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfBankAccounts/bankAccount[" + element + "]/@totalWithHoldingTaxClaim)"));
    }

    public Double calcTotalExpenses() throws XPathExpressionException {
        if (this.totalExpenses != null && this.totalExpenses.isNaN()) {
            this.totalExpenses = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfExpenses/expense/@expenses)"));
        }
        return this.totalExpenses;
    }

    public Double calcTotalExpensesDeductible() throws XPathExpressionException {
        if (this.totalExpensesDeductible != null && this.totalExpensesDeductible.isNaN()) {
            this.totalExpensesDeductible = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfExpenses/expense/@expensesDeductible)"));
        }
        return this.totalExpensesDeductible;
    }

    public Double calcTotalExpensesDeductibleCanton() throws XPathExpressionException {
        if (this.totalExpensesDeductibleCanton != null && this.totalExpensesDeductibleCanton.isNaN()) {
            this.totalExpensesDeductibleCanton = null;
            int expenses = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfExpenses/expense)");
            for (int expense = 1; expense <= expenses; ++expense) {
                Double expensesDeductible = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductible");
                Double expensesDeductibleCanton = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductibleCanton"), expensesDeductible);
                if (expensesDeductibleCanton == null) continue;
                this.totalExpensesDeductibleCanton = TaxStatementReportUtil.nvl(this.totalExpensesDeductibleCanton, 0.0) + expensesDeductibleCanton;
            }
            this.totalExpensesDeductibleCanton = TaxStatementReportUtil.round(this.totalExpensesDeductibleCanton);
        }
        return this.totalExpensesDeductibleCanton;
    }

    public Double calcTotalLiabilityAccountTaxValue() throws XPathExpressionException {
        if (this.totalLiabilityAccountTaxValue != null && this.totalLiabilityAccountTaxValue.isNaN()) {
            this.totalLiabilityAccountTaxValue = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfLiabilities/liabilityAccount/@totalTaxValue)"));
        }
        return this.totalLiabilityAccountTaxValue;
    }

    public Double calcTotalLiabilityAccountTaxValue(int element) throws XPathExpressionException {
        return TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfLiabilities/liabilityAccount[" + element + "]/@totalTaxValue)"));
    }

    public Double calcTotalLiabilityAccountGrossRevenueB() throws XPathExpressionException {
        if (this.totalLiabilityAccountGrossRevenueB != null && this.totalLiabilityAccountGrossRevenueB.isNaN()) {
            this.totalLiabilityAccountGrossRevenueB = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfLiabilities/liabilityAccount/@totalGrossRevenueB)"));
        }
        return this.totalLiabilityAccountGrossRevenueB;
    }

    public Double calcTotalLiabilityAccountGrossRevenueB(int element) throws XPathExpressionException {
        return TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfLiabilities/liabilityAccount[" + element + "]/@totalGrossRevenueB)"));
    }

    public Double calcTotalSecurityTaxValue() throws ParseException, XPathExpressionException {
        if (this.totalSecurityTaxValue != null && this.totalSecurityTaxValue.isNaN()) {
            this.totalSecurityTaxValue = null;
            this.totalSecurityTaxValueOther = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                    if (taxValue != null && category != null && !category.equals("COINBULL")) {
                        this.totalSecurityTaxValue = TaxStatementReportUtil.nvl(this.totalSecurityTaxValue, 0.0) + taxValue;
                    }
                    if (taxValue == null || category == null || !category.equals("COINBULL")) continue;
                    this.totalSecurityTaxValueOther = TaxStatementReportUtil.nvl(this.totalSecurityTaxValueOther, 0.0) + taxValue;
                }
            }
            this.totalSecurityTaxValue = TaxStatementReportUtil.round(this.totalSecurityTaxValue);
            this.totalSecurityTaxValueOther = TaxStatementReportUtil.round(this.totalSecurityTaxValueOther);
        }
        return this.totalSecurityTaxValue;
    }

    public Double calcTotalSecurityTaxValueOther() throws ParseException, XPathExpressionException {
        if (this.totalSecurityTaxValueOther != null && this.totalSecurityTaxValueOther.isNaN()) {
            this.totalSecurityTaxValueOther = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                    if (taxValue == null || category == null || !category.equals("COINBULL")) continue;
                    this.totalSecurityTaxValueOther = TaxStatementReportUtil.nvl(this.totalSecurityTaxValueOther, 0.0) + taxValue;
                }
            }
            this.totalSecurityTaxValueOther = TaxStatementReportUtil.round(this.totalSecurityTaxValueOther);
        }
        return this.totalSecurityTaxValueOther;
    }

    public Double calcTotalSecurityGrossRevenueA() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueA != null && this.totalSecurityGrossRevenueA.isNaN()) {
            this.totalSecurityGrossRevenueA = null;
            this.totalSecurityGrossRevenueACanton = null;
            this.totalSecurityGrossRevenueAIUPPositive = null;
            this.totalSecurityGrossRevenueAIUPNegative = null;
            this.totalSecurityWithHoldingTaxClaim = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueACanton = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueACanton"), grossRevenueA);
                        Double withHoldingTaxClaim = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA != null && (grossRevenueA >= 0.0 || !iup.booleanValue())) {
                            this.totalSecurityGrossRevenueA = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueA, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueACanton != null && (grossRevenueACanton >= 0.0 || !iup.booleanValue())) {
                            this.totalSecurityGrossRevenueACanton = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueACanton, 0.0) + grossRevenueACanton;
                        }
                        if (grossRevenueA != null && grossRevenueA >= 0.0 && iup.booleanValue()) {
                            this.totalSecurityGrossRevenueAIUPPositive = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueAIUPPositive, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueA != null && grossRevenueA < 0.0 && iup.booleanValue()) {
                            this.totalSecurityGrossRevenueAIUPNegative = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueAIUPNegative, 0.0) + grossRevenueA;
                        }
                        if (withHoldingTaxClaim == null || !(withHoldingTaxClaim >= 0.0) && iup.booleanValue()) continue;
                        this.totalSecurityWithHoldingTaxClaim = TaxStatementReportUtil.nvl(this.totalSecurityWithHoldingTaxClaim, 0.0) + withHoldingTaxClaim;
                    }
                }
            }
            this.totalSecurityGrossRevenueA = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueA);
            this.totalSecurityGrossRevenueACanton = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueACanton);
            this.totalSecurityGrossRevenueAIUPPositive = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueAIUPPositive);
            this.totalSecurityGrossRevenueAIUPNegative = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueAIUPNegative);
            this.totalSecurityWithHoldingTaxClaim = TaxStatementReportUtil.round(this.totalSecurityWithHoldingTaxClaim);
        }
        return this.totalSecurityGrossRevenueA;
    }

    public Double calcTotalSecurityGrossRevenueACanton() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueACanton != null && this.totalSecurityGrossRevenueACanton.isNaN()) {
            this.totalSecurityGrossRevenueACanton = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueACanton = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueACanton"), grossRevenueA);
                        Boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueACanton == null || !(grossRevenueACanton >= 0.0) && iup.booleanValue()) continue;
                        this.totalSecurityGrossRevenueACanton = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueACanton, 0.0) + grossRevenueACanton;
                    }
                }
            }
            this.totalSecurityGrossRevenueACanton = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueACanton);
        }
        return this.totalSecurityGrossRevenueACanton;
    }

    public Double calcTotalSecurityGrossRevenueAIUPPositive() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueAIUPPositive != null && this.totalSecurityGrossRevenueAIUPPositive.isNaN()) {
            this.totalSecurityGrossRevenueAIUPPositive = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA == null || !(grossRevenueA >= 0.0) || !iup.booleanValue()) continue;
                        this.totalSecurityGrossRevenueAIUPPositive = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueAIUPPositive, 0.0) + grossRevenueA;
                    }
                }
            }
            this.totalSecurityGrossRevenueAIUPPositive = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueAIUPPositive);
        }
        return this.totalSecurityGrossRevenueAIUPPositive;
    }

    public Double calcTotalSecurityGrossRevenueAIUPNegative() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueAIUPNegative != null && this.totalSecurityGrossRevenueAIUPNegative.isNaN()) {
            this.totalSecurityGrossRevenueAIUPNegative = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA == null || !(grossRevenueA < 0.0) || !iup.booleanValue()) continue;
                        this.totalSecurityGrossRevenueAIUPNegative = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueAIUPNegative, 0.0) + grossRevenueA;
                    }
                }
            }
            this.totalSecurityGrossRevenueAIUPNegative = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueAIUPNegative);
        }
        return this.totalSecurityGrossRevenueAIUPNegative;
    }

    public Double calcTotalSecurityGrossRevenueB() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueB != null && this.totalSecurityGrossRevenueB.isNaN()) {
            this.totalSecurityGrossRevenueB = null;
            this.totalSecurityGrossRevenueBCanton = null;
            this.totalSecurityGrossRevenueBIUPPositive = null;
            this.totalSecurityGrossRevenueBIUPNegative = null;
            this.totalSecurityGrossRevenueBRetrocession = null;
            this.totalSecurityGrossRevenueBSecuritiesLending = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Double grossRevenueBCanton = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueBCanton"), grossRevenueB);
                        boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        boolean lending = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        boolean retro = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        if (!(grossRevenueB == null || !(grossRevenueB >= 0.0) && iup || lending || retro)) {
                            this.totalSecurityGrossRevenueB = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueB, 0.0) + grossRevenueB;
                        }
                        if (!(grossRevenueBCanton == null || !(grossRevenueBCanton >= 0.0) && iup || lending || retro)) {
                            this.totalSecurityGrossRevenueBCanton = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBCanton, 0.0) + grossRevenueBCanton;
                        }
                        if (grossRevenueB != null && grossRevenueB >= 0.0 && iup) {
                            this.totalSecurityGrossRevenueBIUPPositive = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBIUPPositive, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && grossRevenueB < 0.0 && iup) {
                            this.totalSecurityGrossRevenueBIUPNegative = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBIUPNegative, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && grossRevenueB >= 0.0 && retro) {
                            this.totalSecurityGrossRevenueBRetrocession = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBRetrocession, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !lending) continue;
                        this.totalSecurityGrossRevenueBSecuritiesLending = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBSecuritiesLending, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueB = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueB);
            this.totalSecurityGrossRevenueBCanton = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBCanton);
            this.totalSecurityGrossRevenueBIUPPositive = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBIUPPositive);
            this.totalSecurityGrossRevenueBIUPNegative = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBIUPNegative);
            this.totalSecurityGrossRevenueBRetrocession = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBRetrocession);
            this.totalSecurityGrossRevenueBSecuritiesLending = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBSecuritiesLending);
        }
        return this.totalSecurityGrossRevenueB;
    }

    public Double calcTotalSecurityGrossRevenueBCanton() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueBCanton != null && this.totalSecurityGrossRevenueBCanton.isNaN()) {
            this.totalSecurityGrossRevenueBCanton = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Double grossRevenueBCanton = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueBCanton"), grossRevenueB);
                        boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        boolean lending = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        boolean retro = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        if (grossRevenueBCanton == null || !(grossRevenueBCanton >= 0.0) && iup || lending || retro) continue;
                        this.totalSecurityGrossRevenueBCanton = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBCanton, 0.0) + grossRevenueBCanton;
                    }
                }
            }
            this.totalSecurityGrossRevenueBCanton = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBCanton);
        }
        return this.totalSecurityGrossRevenueBCanton;
    }

    public Double calcTotalSecurityGrossRevenueBIUPPositive() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueBIUPPositive != null && this.totalSecurityGrossRevenueBIUPPositive.isNaN()) {
            this.totalSecurityGrossRevenueBIUPPositive = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !iup) continue;
                        this.totalSecurityGrossRevenueBIUPPositive = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBIUPPositive, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueBIUPPositive = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBIUPPositive);
        }
        return this.totalSecurityGrossRevenueBIUPPositive;
    }

    public Double calcTotalSecurityGrossRevenueBIUPNegative() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueBIUPNegative != null && this.totalSecurityGrossRevenueBIUPNegative.isNaN()) {
            this.totalSecurityGrossRevenueBIUPNegative = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueB == null || !(grossRevenueB < 0.0) || !iup) continue;
                        this.totalSecurityGrossRevenueBIUPNegative = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBIUPNegative, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueBIUPNegative = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBIUPNegative);
        }
        return this.totalSecurityGrossRevenueBIUPNegative;
    }

    public Double calcTotalSecurityGrossRevenueBRetrocession() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueBRetrocession != null && this.totalSecurityGrossRevenueBRetrocession.isNaN()) {
            this.totalSecurityGrossRevenueBRetrocession = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean retro = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !retro) continue;
                        this.totalSecurityGrossRevenueBRetrocession = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBRetrocession, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueBRetrocession = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBRetrocession);
        }
        return this.totalSecurityGrossRevenueBRetrocession;
    }

    public Double calcTotalSecurityGrossRevenueBSecuritiesLending() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueBSecuritiesLending != null && this.totalSecurityGrossRevenueBSecuritiesLending.isNaN()) {
            this.totalSecurityGrossRevenueBSecuritiesLending = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean lending = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !lending) continue;
                        this.totalSecurityGrossRevenueBSecuritiesLending = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueBSecuritiesLending, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueBSecuritiesLending = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueBSecuritiesLending);
        }
        return this.totalSecurityGrossRevenueBSecuritiesLending;
    }

    public Double calcTotalSecurityGrossRevenueConversion() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueConversion != null && this.totalSecurityGrossRevenueConversion.isNaN()) {
            this.totalSecurityGrossRevenueConversion = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean conversion = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@conversion"), false);
                        if (grossRevenueA != null && grossRevenueA >= 0.0 && conversion) {
                            this.totalSecurityGrossRevenueConversion = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueConversion, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !conversion) continue;
                        this.totalSecurityGrossRevenueConversion = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueConversion, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueConversion = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueConversion);
        }
        return this.totalSecurityGrossRevenueConversion;
    }

    public Double calcTotalSecurityGrossRevenueIUP() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueIUP != null && this.totalSecurityGrossRevenueIUP.isNaN()) {
            this.totalSecurityGrossRevenueIUP = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA != null && grossRevenueA > 0.0 && iup) {
                            this.totalSecurityGrossRevenueIUP = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueIUP, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueB == null || !(grossRevenueB > 0.0) || !iup) continue;
                        this.totalSecurityGrossRevenueIUP = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueIUP, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueIUP = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueIUP);
        }
        return this.totalSecurityGrossRevenueIUP;
    }

    public Double calcTotalSecurityGrossRevenueIUPNet() throws ParseException, XPathExpressionException {
        if (this.totalSecurityGrossRevenueIUPNet != null && this.totalSecurityGrossRevenueIUPNet.isNaN()) {
            this.totalSecurityGrossRevenueIUPNet = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA != null && iup) {
                            this.totalSecurityGrossRevenueIUPNet = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueIUPNet, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueB == null || !iup) continue;
                        this.totalSecurityGrossRevenueIUPNet = TaxStatementReportUtil.nvl(this.totalSecurityGrossRevenueIUPNet, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalSecurityGrossRevenueIUPNet = TaxStatementReportUtil.round(this.totalSecurityGrossRevenueIUPNet);
        }
        return this.totalSecurityGrossRevenueIUPNet;
    }

    public Double calcTotalSecurityWithHoldingTaxClaim() throws ParseException, XPathExpressionException {
        if (this.totalSecurityWithHoldingTaxClaim != null && this.totalSecurityWithHoldingTaxClaim.isNaN()) {
            this.totalSecurityWithHoldingTaxClaim = null;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double withHoldingTaxClaim = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean iup = TaxStatementReportUtil.nvl(TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (withHoldingTaxClaim == null || !(withHoldingTaxClaim >= 0.0) && iup.booleanValue()) continue;
                        this.totalSecurityWithHoldingTaxClaim = TaxStatementReportUtil.nvl(this.totalSecurityWithHoldingTaxClaim, 0.0) + withHoldingTaxClaim;
                    }
                }
            }
            this.totalSecurityWithHoldingTaxClaim = TaxStatementReportUtil.round(this.totalSecurityWithHoldingTaxClaim);
        }
        return this.totalSecurityWithHoldingTaxClaim;
    }

    public Double calcTotalSecurityLumpSumTaxCredit() throws ParseException, XPathExpressionException {
        if (this.totalSecurityLumpSumTaxCredit != null && this.totalSecurityLumpSumTaxCredit.isNaN()) {
            this.totalSecurityLumpSumTaxCredit = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfSecurities/depot/security/payment/@lumpSumTaxCreditAmount)"));
        }
        return this.totalSecurityLumpSumTaxCredit;
    }

    public Double calcTotalSecurityNonRecoverableTax() throws ParseException, XPathExpressionException {
        if (this.totalSecurityNonRecoverableTax != null && this.totalSecurityNonRecoverableTax.isNaN()) {
            this.totalSecurityNonRecoverableTax = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfSecurities/depot/security/payment/@nonRecoverableTaxAmount)"));
        }
        return this.totalSecurityNonRecoverableTax;
    }

    public Double calcTotalSecurityAdditionalWithHoldingTaxUSA() throws ParseException, XPathExpressionException {
        if (this.totalSecurityAdditionalWithHoldingTaxUSA != null && this.totalSecurityAdditionalWithHoldingTaxUSA.isNaN()) {
            this.totalSecurityAdditionalWithHoldingTaxUSA = TaxStatementReportUtil.round(TaxStatementReportUtil.getValueNumber(this.doc, "sum (/taxStatement/listOfSecurities/depot/security/payment/@additionalWithHoldingTaxUSA)"));
        }
        return this.totalSecurityAdditionalWithHoldingTaxUSA;
    }

    public Double calcTotalTaxValue() throws ParseException, XPathExpressionException {
        if (this.totalTaxValue != null && this.totalTaxValue.isNaN()) {
            Double totalBankAccountTaxValue = this.calcTotalBankAccountTaxValue();
            Double totalSecurityTaxValue = this.calcTotalSecurityTaxValue();
            this.totalTaxValue = totalBankAccountTaxValue != null || totalSecurityTaxValue != null ? Double.valueOf(TaxStatementReportUtil.nvl(totalBankAccountTaxValue, 0.0) + TaxStatementReportUtil.nvl(totalSecurityTaxValue, 0.0)) : null;
        }
        return this.totalTaxValue;
    }

    public Double calcTotalGrossRevenueA() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueA != null && this.totalGrossRevenueA.isNaN()) {
            Double totalBankAccountGrossRevenueA = this.calcTotalBankAccountGrossRevenueA();
            Double totalSecurityGrossRevenueA = this.calcTotalSecurityGrossRevenueA();
            this.totalGrossRevenueA = totalBankAccountGrossRevenueA != null || totalSecurityGrossRevenueA != null ? Double.valueOf(TaxStatementReportUtil.nvl(totalBankAccountGrossRevenueA, 0.0) + TaxStatementReportUtil.nvl(totalSecurityGrossRevenueA, 0.0)) : null;
        }
        return this.totalGrossRevenueA;
    }

    public Double calcTotalGrossRevenueACanton() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueACanton != null && this.totalGrossRevenueACanton.isNaN()) {
            Double totalBankAccountGrossRevenueA = this.calcTotalBankAccountGrossRevenueA();
            Double totalSecurityGrossRevenueACanton = this.calcTotalSecurityGrossRevenueACanton();
            this.totalGrossRevenueACanton = totalBankAccountGrossRevenueA != null || totalSecurityGrossRevenueACanton != null ? Double.valueOf(TaxStatementReportUtil.nvl(totalBankAccountGrossRevenueA, 0.0) + TaxStatementReportUtil.nvl(totalSecurityGrossRevenueACanton, 0.0)) : null;
        }
        return this.totalGrossRevenueACanton;
    }

    public Double calcTotalGrossRevenueB() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueB != null && this.totalGrossRevenueB.isNaN()) {
            Double totalBankAccountGrossRevenueB = this.calcTotalBankAccountGrossRevenueB();
            Double totalSecurityGrossRevenueB = this.calcTotalSecurityGrossRevenueB();
            this.totalGrossRevenueB = totalBankAccountGrossRevenueB != null || totalSecurityGrossRevenueB != null ? Double.valueOf(TaxStatementReportUtil.nvl(totalBankAccountGrossRevenueB, 0.0) + TaxStatementReportUtil.nvl(totalSecurityGrossRevenueB, 0.0)) : null;
        }
        return this.totalGrossRevenueB;
    }

    public Double calcTotalGrossRevenueBCanton() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueBCanton != null && this.totalGrossRevenueBCanton.isNaN()) {
            Double totalBankAccountGrossRevenueB = this.calcTotalBankAccountGrossRevenueB();
            Double totalSecurityGrossRevenueBCanton = this.calcTotalSecurityGrossRevenueBCanton();
            this.totalGrossRevenueBCanton = totalBankAccountGrossRevenueB != null || totalSecurityGrossRevenueBCanton != null ? Double.valueOf(TaxStatementReportUtil.nvl(totalBankAccountGrossRevenueB, 0.0) + TaxStatementReportUtil.nvl(totalSecurityGrossRevenueBCanton, 0.0)) : null;
        }
        return this.totalGrossRevenueBCanton;
    }

    public Double calcTotalWithHoldingTaxClaim() throws ParseException, XPathExpressionException {
        if (this.totalWithHoldingTaxClaim != null && this.totalWithHoldingTaxClaim.isNaN()) {
            Double totalBankAccountWithHoldingTaxClaim = this.calcTotalBankAccountWithHoldingTaxClaim();
            Double totalSecurityWithHoldingTaxClaim = this.calcTotalSecurityWithHoldingTaxClaim();
            this.totalWithHoldingTaxClaim = totalBankAccountWithHoldingTaxClaim != null || totalSecurityWithHoldingTaxClaim != null ? Double.valueOf(TaxStatementReportUtil.nvl(totalBankAccountWithHoldingTaxClaim, 0.0) + TaxStatementReportUtil.nvl(totalSecurityWithHoldingTaxClaim, 0.0)) : null;
        }
        return this.totalWithHoldingTaxClaim;
    }

    public Boolean calcExDate() throws ParseException, XPathExpressionException {
        if (this.exDate == null) {
            this.exDate = false;
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots && !this.exDate.booleanValue(); ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities && !this.exDate.booleanValue(); ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments && !this.exDate.booleanValue(); ++payment) {
                        Date exDate = TaxStatementReportUtil.getValueDate(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@exDate");
                        this.exDate = exDate != null;
                    }
                }
            }
        }
        return this.exDate;
    }

    public Boolean calcIgnoreDigits() throws ParseException, XPathExpressionException {
        if (this.ignoreDigits == null) {
            this.ignoreDigits = true;
            Double bankTotalTaxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/@totalTaxValue");
            if (bankTotalTaxValue != null && bankTotalTaxValue != (double)Math.round(bankTotalTaxValue) && bankTotalTaxValue != (double)bankTotalTaxValue.longValue() && bankTotalTaxValue != (double)bankTotalTaxValue.longValue() + 0.5 && bankTotalTaxValue != (double)bankTotalTaxValue.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            int accounts = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
            for (int account = 1; account <= accounts && this.ignoreDigits.booleanValue(); ++account) {
                Double totalTaxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalTaxValue");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue/@value");
                if (totalTaxValue != null && totalTaxValue != (double)Math.round(totalTaxValue) && totalTaxValue != (double)totalTaxValue.longValue() && totalTaxValue != (double)totalTaxValue.longValue() + 0.5 && totalTaxValue != (double)totalTaxValue.longValue() + 1.0) {
                    this.ignoreDigits = false;
                }
                if (taxValue == null || taxValue == (double)Math.round(taxValue) || taxValue == (double)taxValue.longValue() || taxValue == (double)taxValue.longValue() + 0.5 || taxValue == (double)taxValue.longValue() + 1.0) continue;
                this.ignoreDigits = false;
            }
            Double liabilityTotalTaxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfLiabilities/@totalTaxValue");
            if (liabilityTotalTaxValue != null && liabilityTotalTaxValue != (double)Math.round(liabilityTotalTaxValue) && liabilityTotalTaxValue != (double)liabilityTotalTaxValue.longValue() && liabilityTotalTaxValue != (double)liabilityTotalTaxValue.longValue() + 0.5 && liabilityTotalTaxValue != (double)liabilityTotalTaxValue.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            int accounts2 = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfLiabilities/liabilityAccount)");
            for (int account = 1; account <= accounts2 && this.ignoreDigits.booleanValue(); ++account) {
                Double totalTaxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@totalTaxValue");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue/@value");
                if (totalTaxValue != null && totalTaxValue != (double)Math.round(totalTaxValue) && totalTaxValue != (double)totalTaxValue.longValue() && totalTaxValue != (double)totalTaxValue.longValue() + 0.5 && totalTaxValue != (double)totalTaxValue.longValue() + 1.0) {
                    this.ignoreDigits = false;
                }
                if (taxValue == null || taxValue == (double)Math.round(taxValue) || taxValue == (double)taxValue.longValue() || taxValue == (double)taxValue.longValue() + 0.5 || taxValue == (double)taxValue.longValue() + 1.0) continue;
                this.ignoreDigits = false;
            }
            Double expenseTotal = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/@totalExpenses");
            Double expenseTotalDeductible = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/@totalExpensesDeductible");
            Double expenseTotalDeductibleCanton = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/@totalExpensesDeductibleCanton");
            if (expenseTotal != null && expenseTotal != (double)Math.round(expenseTotal) && expenseTotal != (double)expenseTotal.longValue() && expenseTotal != (double)expenseTotal.longValue() + 0.5 && expenseTotal != (double)expenseTotal.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            if (expenseTotalDeductible != null && expenseTotalDeductible != (double)Math.round(expenseTotalDeductible) && expenseTotalDeductible != (double)expenseTotalDeductible.longValue() && expenseTotalDeductible != (double)expenseTotalDeductible.longValue() + 0.5 && expenseTotalDeductible != (double)expenseTotalDeductible.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            if (expenseTotalDeductibleCanton != null && expenseTotalDeductibleCanton != (double)Math.round(expenseTotalDeductibleCanton) && expenseTotalDeductibleCanton != (double)expenseTotalDeductibleCanton.longValue() && expenseTotalDeductibleCanton != (double)expenseTotalDeductibleCanton.longValue() + 0.5 && expenseTotalDeductibleCanton != (double)expenseTotalDeductibleCanton.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            int expenses = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfExpenses/expense)");
            for (int expense = 1; expense <= expenses && this.ignoreDigits.booleanValue(); ++expense) {
                Double expenseValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expenses");
                Double expenseDeductible = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductible");
                Double expenseDeductibleCanton = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductibleCanton");
                if (expenseValue != null && expenseValue != (double)Math.round(expenseValue) && expenseValue != (double)expenseValue.longValue() && expenseValue != (double)expenseValue.longValue() + 0.5 && expenseValue != (double)expenseValue.longValue() + 1.0) {
                    this.ignoreDigits = false;
                }
                if (expenseDeductible != null && expenseDeductible != (double)Math.round(expenseDeductible) && expenseDeductible != (double)expenseDeductible.longValue() && expenseDeductible != (double)expenseDeductible.longValue() + 0.5 && expenseDeductible != (double)expenseDeductible.longValue() + 1.0) {
                    this.ignoreDigits = false;
                }
                if (expenseDeductibleCanton == null || expenseDeductibleCanton == (double)Math.round(expenseDeductibleCanton) || expenseDeductibleCanton == (double)expenseDeductibleCanton.longValue() || expenseDeductibleCanton == (double)expenseDeductibleCanton.longValue() + 0.5 || expenseDeductibleCanton == (double)expenseDeductibleCanton.longValue() + 1.0) continue;
                this.ignoreDigits = false;
            }
            Double securityTotalTaxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/@totalTaxValue");
            if (securityTotalTaxValue != null && securityTotalTaxValue != (double)Math.round(securityTotalTaxValue) && securityTotalTaxValue != (double)securityTotalTaxValue.longValue() && securityTotalTaxValue != (double)securityTotalTaxValue.longValue() + 0.5 && securityTotalTaxValue != (double)securityTotalTaxValue.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots && this.ignoreDigits.booleanValue(); ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities && this.ignoreDigits.booleanValue(); ++security) {
                    Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                    if (taxValue == null || taxValue == (double)Math.round(taxValue) || taxValue == (double)taxValue.longValue() || taxValue == (double)taxValue.longValue() + 0.5 || taxValue == (double)taxValue.longValue() + 1.0) continue;
                    this.ignoreDigits = false;
                }
            }
            Double totalTaxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/@totalTaxValue");
            Double totalGrossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/@totalGrossRevenueA");
            Double totalGrossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/@totalGrossRevenueB");
            if (totalTaxValue != null && totalTaxValue != (double)Math.round(totalTaxValue) && totalTaxValue != (double)totalTaxValue.longValue() && totalTaxValue != (double)totalTaxValue.longValue() + 0.5 && totalTaxValue != (double)totalTaxValue.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            if (totalGrossRevenueA != null && totalGrossRevenueA != (double)Math.round(totalGrossRevenueA) && totalGrossRevenueA != (double)totalGrossRevenueA.longValue() && totalGrossRevenueA != (double)totalGrossRevenueA.longValue() + 0.5 && totalGrossRevenueA != (double)totalGrossRevenueA.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
            if (totalGrossRevenueB != null && totalGrossRevenueB != (double)Math.round(totalGrossRevenueB) && totalGrossRevenueB != (double)totalGrossRevenueB.longValue() && totalGrossRevenueB != (double)totalGrossRevenueB.longValue() + 0.5 && totalGrossRevenueB != (double)totalGrossRevenueB.longValue() + 1.0) {
                this.ignoreDigits = false;
            }
        }
        return this.ignoreDigits;
    }

    public Boolean calcWithHoldingTax() throws ParseException, XPathExpressionException {
        if (this.withHoldingTax == null) {
            this.withHoldingTax = false;
            int accounts = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
            for (int account = 1; account <= accounts && !this.withHoldingTax.booleanValue(); ++account) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment)");
                for (int payment = 1; payment <= payments && !this.withHoldingTax.booleanValue(); ++payment) {
                    Double withHoldingTaxClaim = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                    this.withHoldingTax = withHoldingTaxClaim != null;
                }
            }
            int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots && !this.withHoldingTax.booleanValue(); ++depot) {
                int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities && !this.withHoldingTax.booleanValue(); ++security) {
                    int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments && !this.withHoldingTax.booleanValue(); ++payment) {
                        Double withHoldingTaxClaim = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        this.withHoldingTax = withHoldingTaxClaim != null;
                    }
                }
            }
        }
        return this.withHoldingTax;
    }

    public Double calcTaxValueA() throws ParseException, XPathExpressionException {
        Double totalTaxValueA = null;
        int accounts = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
        for (int account = 1; account <= accounts; ++account) {
            int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment)");
            boolean withHoldingTax = false;
            for (int payment = 1; payment <= payments && !withHoldingTax; ++payment) {
                Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueA");
                if (grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                withHoldingTax = true;
            }
            String country = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCountry");
            Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue/@value");
            if (payments == 0 && country != null && country.equals("CH")) {
                withHoldingTax = true;
            }
            if (!withHoldingTax || taxValue == null) continue;
            totalTaxValueA = TaxStatementReportUtil.nvl(totalTaxValueA, 0.0) + taxValue;
        }
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                boolean withHoldingTax = false;
                for (int payment = 1; payment <= payments && !withHoldingTax; ++payment) {
                    Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                    if (grossRevenueA == null || grossRevenueA == 0.0) continue;
                    withHoldingTax = true;
                }
                String country = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                String category = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                if (payments == 0 && country != null && country.equals("CH")) {
                    withHoldingTax = true;
                }
                if (!withHoldingTax || category == null || category.equals("COINBULL") || taxValue == null) continue;
                totalTaxValueA = TaxStatementReportUtil.nvl(totalTaxValueA, 0.0) + taxValue;
            }
        }
        return totalTaxValueA;
    }

    public Double calcTaxValueB() throws ParseException, XPathExpressionException {
        Double totalTaxValueB = null;
        int accounts = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
        for (int account = 1; account <= accounts; ++account) {
            int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment)");
            boolean withHoldingTax = false;
            for (int payment = 1; payment <= payments && !withHoldingTax; ++payment) {
                Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueA");
                if (grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                withHoldingTax = true;
            }
            String country = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCountry");
            Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue/@value");
            if (payments == 0 && country != null && country.equals("CH")) {
                withHoldingTax = true;
            }
            if (withHoldingTax || taxValue == null) continue;
            totalTaxValueB = TaxStatementReportUtil.nvl(totalTaxValueB, 0.0) + taxValue;
        }
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                boolean withHoldingTax = false;
                boolean lumpSumTaxCredit = false;
                boolean additionalWithHoldingTax = false;
                for (int payment = 1; !(payment > payments || withHoldingTax || lumpSumTaxCredit || additionalWithHoldingTax); ++payment) {
                    Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                    Double nonRecoverableTaxAmount = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                    Double additionalWithHoldingTaxUSA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                    if (grossRevenueA != null && grossRevenueA != 0.0) {
                        withHoldingTax = true;
                    }
                    if (nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
                        lumpSumTaxCredit = true;
                    }
                    if (additionalWithHoldingTaxUSA == null || !(additionalWithHoldingTaxUSA > 0.0)) continue;
                    additionalWithHoldingTax = true;
                }
                String country = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                String category = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                if (payments == 0 && country != null && country.equals("CH")) {
                    withHoldingTax = true;
                }
                if (withHoldingTax || lumpSumTaxCredit || additionalWithHoldingTax || category == null || category.equals("COINBULL") || taxValue == null) continue;
                totalTaxValueB = TaxStatementReportUtil.nvl(totalTaxValueB, 0.0) + taxValue;
            }
        }
        return totalTaxValueB;
    }

    public Double calcTaxValueCoinBullion() throws ParseException, XPathExpressionException {
        Double totalTaxValueCoinBullion = null;
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                String category = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                if (category == null || !category.equals("COINBULL") || taxValue == null) continue;
                totalTaxValueCoinBullion = TaxStatementReportUtil.nvl(totalTaxValueCoinBullion, 0.0) + taxValue;
            }
        }
        return totalTaxValueCoinBullion;
    }

    public Double calcTaxValueDA1() throws ParseException, XPathExpressionException {
        Double totalTaxValueDA1 = null;
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                boolean withHoldingTax = false;
                boolean lumpSumTaxCredit = false;
                boolean additionalWithHoldingTax = false;
                for (int payment = 1; !(payment > payments || withHoldingTax || lumpSumTaxCredit || additionalWithHoldingTax); ++payment) {
                    Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                    Double nonRecoverableTaxAmount = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                    Double additionalWithHoldingTaxUSA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                    if (grossRevenueA != null && grossRevenueA != 0.0) {
                        withHoldingTax = true;
                    }
                    if (nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
                        lumpSumTaxCredit = true;
                    }
                    if (additionalWithHoldingTaxUSA == null || !(additionalWithHoldingTaxUSA > 0.0)) continue;
                    additionalWithHoldingTax = true;
                }
                String country = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                if (payments == 0 && country != null && country.equals("CH")) {
                    withHoldingTax = true;
                }
                if (withHoldingTax || !lumpSumTaxCredit || additionalWithHoldingTax || taxValue == null) continue;
                totalTaxValueDA1 = TaxStatementReportUtil.nvl(totalTaxValueDA1, 0.0) + taxValue;
            }
        }
        return totalTaxValueDA1;
    }

    public Double calcTaxValueOther() throws ParseException, XPathExpressionException {
        Double totalTaxValueOther = null;
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                String category = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                if (category == null || !category.equals("OTHER") || taxValue == null) continue;
                totalTaxValueOther = TaxStatementReportUtil.nvl(totalTaxValueOther, 0.0) + taxValue;
            }
        }
        return totalTaxValueOther;
    }

    public Double calcTaxValueToken() throws ParseException, XPathExpressionException {
        Double totalTaxValueToken = null;
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                String category = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                if (category == null || !category.equals("CURRNOTE") || taxValue == null) continue;
                totalTaxValueToken = TaxStatementReportUtil.nvl(totalTaxValueToken, 0.0) + taxValue;
            }
        }
        return totalTaxValueToken;
    }

    public Double calcTaxValueUSA() throws ParseException, XPathExpressionException {
        Double totalTaxValueUSA = null;
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                boolean withHoldingTax = false;
                boolean lumpSumTaxCredit = false;
                boolean additionalWithHoldingTax = false;
                for (int payment = 1; !(payment > payments || withHoldingTax || lumpSumTaxCredit || additionalWithHoldingTax); ++payment) {
                    Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                    Double nonRecoverableTaxAmount = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                    Double additionalWithHoldingTaxUSA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                    if (grossRevenueA != null && grossRevenueA != 0.0) {
                        withHoldingTax = true;
                    }
                    if (nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
                        lumpSumTaxCredit = true;
                    }
                    if (additionalWithHoldingTaxUSA == null || !(additionalWithHoldingTaxUSA > 0.0)) continue;
                    additionalWithHoldingTax = true;
                }
                String country = TaxStatementReportUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                Double taxValue = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                if (payments == 0 && country != null && country.equals("CH")) {
                    withHoldingTax = true;
                }
                if (withHoldingTax || !lumpSumTaxCredit || !additionalWithHoldingTax || taxValue == null) continue;
                totalTaxValueUSA = TaxStatementReportUtil.nvl(totalTaxValueUSA, 0.0) + taxValue;
            }
        }
        return totalTaxValueUSA;
    }

    public Double calcGrossRevenueA() throws ParseException, XPathExpressionException {
        Double totalGrossRevenueA = null;
        int accounts = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
        for (int account = 1; account <= accounts; ++account) {
            int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment)");
            for (int payment = 1; payment <= payments; ++payment) {
                Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueA");
                if (grossRevenueA == null || !(grossRevenueA > 0.0)) continue;
                totalGrossRevenueA = TaxStatementReportUtil.nvl(totalGrossRevenueA, 0.0) + grossRevenueA;
            }
        }
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                for (int payment = 1; payment <= payments; ++payment) {
                    Double grossRevenueA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                    if (grossRevenueA == null || grossRevenueA == 0.0) continue;
                    totalGrossRevenueA = TaxStatementReportUtil.nvl(totalGrossRevenueA, 0.0) + grossRevenueA;
                }
            }
        }
        return totalGrossRevenueA;
    }

    public Double calcGrossRevenueB() throws ParseException, XPathExpressionException {
        Double totalGrossRevenueB = null;
        int accounts = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
        for (int account = 1; account <= accounts; ++account) {
            int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment)");
            for (int payment = 1; payment <= payments; ++payment) {
                Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueB");
                if (grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                totalGrossRevenueB = TaxStatementReportUtil.nvl(totalGrossRevenueB, 0.0) + grossRevenueB;
            }
        }
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                for (int payment = 1; payment <= payments; ++payment) {
                    Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                    Double nonRecoverableTaxAmount = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                    Double additionalWithHoldingTaxUSA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                    Boolean iup = TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup", false);
                    Boolean retrocession = TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession", false);
                    Boolean lending = TaxStatementReportUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee", false);
                    boolean lumpSumTaxCredit = false;
                    boolean additionalWithHoldingTax = false;
                    if (nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
                        lumpSumTaxCredit = true;
                    }
                    if (additionalWithHoldingTaxUSA != null && additionalWithHoldingTaxUSA > 0.0) {
                        additionalWithHoldingTax = true;
                    }
                    if (lumpSumTaxCredit || additionalWithHoldingTax || retrocession.booleanValue() || lending.booleanValue() || grossRevenueB == null || !(grossRevenueB > 0.0) && iup.booleanValue()) continue;
                    totalGrossRevenueB = TaxStatementReportUtil.nvl(totalGrossRevenueB, 0.0) + grossRevenueB;
                }
            }
        }
        return totalGrossRevenueB;
    }

    public Double calcGrossRevenueDA1() throws ParseException, XPathExpressionException {
        Double totalGrossRevenueDA1 = null;
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                for (int payment = 1; payment <= payments; ++payment) {
                    Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                    Double nonRecoverableTaxAmount = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                    Double additionalWithHoldingTaxUSA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                    boolean lumpSumTaxCredit = false;
                    boolean additionalWithHoldingTax = false;
                    if (nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
                        lumpSumTaxCredit = true;
                    }
                    if (additionalWithHoldingTaxUSA != null && additionalWithHoldingTaxUSA > 0.0) {
                        additionalWithHoldingTax = true;
                    }
                    if (!lumpSumTaxCredit || additionalWithHoldingTax || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    totalGrossRevenueDA1 = TaxStatementReportUtil.nvl(totalGrossRevenueDA1, 0.0) + grossRevenueB;
                }
            }
        }
        return totalGrossRevenueDA1;
    }

    public Double calcGrossRevenueUSA() throws ParseException, XPathExpressionException {
        Double totalGrossRevenueUSA = null;
        int depots = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                int payments = TaxStatementReportUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                for (int payment = 1; payment <= payments; ++payment) {
                    Double grossRevenueB = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                    Double nonRecoverableTaxAmount = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                    Double additionalWithHoldingTaxUSA = TaxStatementReportUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                    boolean lumpSumTaxCredit = false;
                    boolean additionalWithHoldingTax = false;
                    if (nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
                        lumpSumTaxCredit = true;
                    }
                    if (additionalWithHoldingTaxUSA != null && additionalWithHoldingTaxUSA > 0.0) {
                        additionalWithHoldingTax = true;
                    }
                    if (!lumpSumTaxCredit || !additionalWithHoldingTax || grossRevenueB == null || !(grossRevenueB > 0.0)) continue;
                    totalGrossRevenueUSA = TaxStatementReportUtil.nvl(totalGrossRevenueUSA, 0.0) + grossRevenueB;
                }
            }
        }
        return totalGrossRevenueUSA;
    }

    public Boolean approximately(Double a, Double b) throws ParseException, XPathExpressionException {
        return this.approximately(a, b, this.calcIgnoreDigits());
    }

    public Boolean approximately(Double a, Double b, Boolean ignore) {
        Boolean approximately = false;
        if (a == null && b == null) {
            approximately = true;
        } else if (a != null && b == null) {
            approximately = false;
        } else if (a == null && b != null) {
            approximately = false;
        } else if (a == b) {
            approximately = true;
        } else if (a.longValue() == b.longValue() && ignore.booleanValue()) {
            approximately = true;
        } else if (a.longValue() == b.longValue() + 1L && ignore.booleanValue()) {
            approximately = true;
        } else if (a.longValue() + 1L == b.longValue() && ignore.booleanValue()) {
            approximately = true;
        }
        return approximately;
    }

    public TaxStatementReportFormula(Document doc) throws ParseException, XPathExpressionException {
        this.doc = doc;
        this.calcExDate();
        this.calcIgnoreDigits();
        this.calcWithHoldingTax();
        this.calcTotalTaxValue();
        this.calcTotalGrossRevenueA();
        this.calcTotalGrossRevenueB();
    }
}

