/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultContent;
import java.util.ArrayList;
import java.util.List;

public class TaxStatementReportResultList {
    private TaxStatementReportResult result = null;
    private List<TaxStatementReportResultCase> cases = new ArrayList<TaxStatementReportResultCase>();
    private List<TaxStatementReportResultContent> content = new ArrayList<TaxStatementReportResultContent>();

    public TaxStatementReportResult getResult() {
        return this.result;
    }

    public void setResult(TaxStatementReportResult result) {
        this.result = result;
    }

    public List<TaxStatementReportResultCase> getCases() {
        return this.cases;
    }

    public boolean addCase(TaxStatementReportResultCase cs) {
        if (cs != null) {
            if (cs.getResult() == TaxStatementReportResult.ERROR) {
                System.out.print("x");
            } else if (cs.getResult() == TaxStatementReportResult.FATAL) {
                System.out.print("!");
            } else if (cs.getResult() == TaxStatementReportResult.IGNORE) {
                System.out.print(".");
            } else if (cs.getResult() == TaxStatementReportResult.OK) {
                System.out.print(".");
            } else if (cs.getResult() == TaxStatementReportResult.SELECT) {
                System.out.print("o");
            } else if (cs.getResult() == TaxStatementReportResult.WARNING) {
                System.out.print("?");
            }
            if (this.getResult() == null) {
                this.setResult(cs.getResult());
            } else if (cs.getResult() == TaxStatementReportResult.FATAL) {
                this.setResult(cs.getResult());
            } else if (cs.getResult() == TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.FATAL) {
                this.setResult(cs.getResult());
            } else if (cs.getResult() == TaxStatementReportResult.WARNING && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR) {
                this.setResult(cs.getResult());
            } else if (cs.getResult() == TaxStatementReportResult.OK && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.WARNING) {
                this.setResult(cs.getResult());
            } else if (cs.getResult() == TaxStatementReportResult.IGNORE && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.WARNING && this.getResult() != TaxStatementReportResult.OK) {
                this.setResult(cs.getResult());
            } else if (cs.getResult() == TaxStatementReportResult.SELECT) {
                // empty if block
            }
        }
        return this.getCases() != null && this.getCases().add(cs);
    }

    public boolean addCase(List<TaxStatementReportResultCase> cases) {
        boolean b = true;
        if (cases != null) {
            for (TaxStatementReportResultCase cs : cases) {
                b = b && this.addCase(cs);
            }
        }
        return b;
    }

    public List<TaxStatementReportResultContent> getContent() {
        return this.content;
    }

    public String getContent(String id) {
        return this.getContent(id, TaxStatementReportResult.IGNORE);
    }

    public String getContent(String id, TaxStatementReportResult def) {
        Enum value = null;
        if (id != null && id.length() > 0 && this.getContent() != null) {
            for (TaxStatementReportResultContent entry : this.getContent()) {
                if (entry == null || entry.getId() == null || !id.equals(entry.getId())) continue;
                value = entry.getResult();
                break;
            }
        }
        return value != null ? value.toString() : (def != null ? def.toString() : null);
    }

    public void setContent(List<TaxStatementReportResultContent> content) {
        this.content = content;
    }

    public boolean addContent(TaxStatementReportResultContent content) {
        return this.getContent() != null && this.getContent().add(content);
    }

    public List<TaxStatementReportResultCase> extractGroup(String group) {
        ArrayList<TaxStatementReportResultCase> extract = null;
        if (this.getCases() != null && group != null) {
            for (TaxStatementReportResultCase cs : this.getCases()) {
                if (cs == null || cs.getGroup() == null || !cs.getGroup().equals(group)) continue;
                if (extract == null) {
                    extract = new ArrayList<TaxStatementReportResultCase>();
                }
                extract.add(cs);
            }
        }
        return extract;
    }
}

