/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSchemaCase04
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1));
        String id = TaxStatementReportSchemaData.getId(doc);
        if (id != null && id.length() > 0) {
            if (id.length() == 31) {
                entity.setResult(TaxStatementReportResult.OK).setReason(id);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(id);
            }
        } else {
            entity.setResult(TaxStatementReportResult.ERROR);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2));
        String id = TaxStatementReportSchemaData.getId(doc);
        if (id != null && id.length() >= 2) {
            String country = id.substring(0, 2);
            if (country != null && country.equals("CH")) {
                entity.setResult(TaxStatementReportResult.OK).setReason(country);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(country);
            }
        } else if (id != null && id.length() > 0) {
            String country = id.substring(0);
            if (country != null && country.length() > 0) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(country);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        String id = TaxStatementReportSchemaData.getId(doc);
        if (id != null && id.length() >= 7) {
            String clearingNumber = id.substring(2, 7);
            if (clearingNumber != null && clearingNumber.length() == 5) {
                boolean ok = true;
                for (int i = 0; i < 5 && ok; ++i) {
                    ok = clearingNumber.charAt(i) >= '0' && clearingNumber.charAt(i) <= '9';
                }
                entity.setResult(ok ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR).setReason(clearingNumber);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(clearingNumber);
            }
        } else if (id != null && id.length() > 2) {
            String clearingNumber = id.substring(2);
            if (clearingNumber != null && clearingNumber.length() > 0) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(clearingNumber);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        String id = TaxStatementReportSchemaData.getId(doc);
        if (id != null && id.length() >= 21) {
            String originatingNumber = id.substring(7, 21);
            if (originatingNumber != null && originatingNumber.length() == 14) {
                boolean ok = true;
                for (int i = 0; i < 14 && ok; ++i) {
                    ok = originatingNumber.charAt(i) >= '0' && originatingNumber.charAt(i) <= '9' || originatingNumber.charAt(i) >= 'A' && originatingNumber.charAt(i) <= 'Z' || originatingNumber.charAt(i) >= 'a' && originatingNumber.charAt(i) <= 'z';
                }
                entity.setResult(ok ? TaxStatementReportResult.OK : TaxStatementReportResult.ERROR).setReason(originatingNumber);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(originatingNumber);
            }
        } else if (id != null && id.length() > 7) {
            String originatingNumber = id.substring(7);
            if (originatingNumber != null && originatingNumber.length() > 0) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(originatingNumber);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        String id = TaxStatementReportSchemaData.getId(doc);
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
        if (id != null && id.length() >= 29) {
            String referenceDate = id.substring(21, 29);
            if (referenceDate != null && referenceDate.length() == 8 && referenceDate.substring(0, 4).equals(taxPeriod)) {
                if (referenceDate.charAt(0) >= '2' && referenceDate.charAt(0) <= '2' && referenceDate.charAt(1) >= '0' && referenceDate.charAt(1) <= '0' && referenceDate.charAt(2) >= '1' && referenceDate.charAt(2) <= '9' && referenceDate.charAt(3) >= '0' && referenceDate.charAt(3) <= '9' && referenceDate.charAt(4) >= '0' && referenceDate.charAt(4) <= '1' && referenceDate.charAt(5) >= '0' && referenceDate.charAt(5) <= '9' && referenceDate.charAt(6) >= '0' && referenceDate.charAt(6) <= '3' && referenceDate.charAt(7) >= '0' && referenceDate.charAt(7) <= '9') {
                    entity.setResult(TaxStatementReportResult.OK).setReason(referenceDate);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason(referenceDate);
                }
            } else if (periodTo != null) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(referenceDate + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + new SimpleDateFormat("yyyyMMdd").format(periodTo));
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(referenceDate + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + taxPeriod + "1231");
            }
        } else if (id != null && id.length() > 21) {
            String referenceDate = id.substring(21);
            if (referenceDate != null && referenceDate.length() > 0) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(referenceDate);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        String id = TaxStatementReportSchemaData.getId(doc);
        if (id != null && id.length() >= 31) {
            String currentNumber = id.substring(29, 31);
            if (currentNumber != null && currentNumber.length() == 2) {
                if (currentNumber.equals("00")) {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason(currentNumber + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATER) + " 00");
                } else if (currentNumber.charAt(0) >= '0' && currentNumber.charAt(0) <= '9' && currentNumber.charAt(1) >= '0' && currentNumber.charAt(1) <= '9') {
                    entity.setResult(TaxStatementReportResult.OK).setReason(currentNumber);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason(currentNumber);
                }
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(currentNumber);
            }
        } else if (id != null && id.length() > 29) {
            String currentNumber = id.substring(29);
            if (currentNumber != null && currentNumber.length() > 0) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(currentNumber);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultMandatory(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSchemaData.getId(doc) != null));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSchemaData.getId(doc) != null));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSchemaData.getId(doc) != null));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSchemaData.getId(doc) != null));
        cs.addStepResultMandatory(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSchemaData.getId(doc) != null));
        return cs;
    }

    public TaxStatementReportSchemaCase04() {
        super("SCHEMA_CASE", 4);
    }
}

