/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSchemaCase06
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1));
        String version = TaxStatementReportSchemaData.getMinorVersion(doc);
        String country = TaxStatementReportSchemaData.getCountry(doc);
        if (country != null && country.length() == 2) {
            if (country.equals("CH")) {
                entity.setResult(TaxStatementReportResult.OK).setReason(country);
            } else if (country.charAt(0) >= 'A' && country.charAt(0) <= 'Z' && country.charAt(1) >= 'A' && country.charAt(1) <= 'Z' && version != null && version.equals("22")) {
                entity.setResult(TaxStatementReportResult.IGNORE).setReason(country);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(country);
            }
        } else if (country == null && version != null && version.equals("22")) {
            entity.setResult(TaxStatementReportResult.OK).setReason("CH");
        } else {
            entity.setResult(TaxStatementReportResult.ERROR);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2));
        String canton = TaxStatementReportSchemaData.getCanton(doc);
        if (canton != null && canton.length() > 0) {
            if (canton.equals("AG") || canton.equals("AI") || canton.equals("AR") || canton.equals("BE") || canton.equals("BL") || canton.equals("BS") || canton.equals("FR") || canton.equals("GE") || canton.equals("GL") || canton.equals("GR") || canton.equals("JU") || canton.equals("LU") || canton.equals("NE") || canton.equals("NW") || canton.equals("OW") || canton.equals("SG") || canton.equals("SH") || canton.equals("SO") || canton.equals("SZ") || canton.equals("TG") || canton.equals("TI") || canton.equals("UR") || canton.equals("VD") || canton.equals("VS") || canton.equals("ZG") || canton.equals("ZH")) {
                entity.setResult(TaxStatementReportResult.OK).setReason(canton);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(canton);
            }
        } else {
            entity.setResult(TaxStatementReportResult.ERROR);
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultMandatory(ok[2], this.execute02(doc, lang, formula));
        return cs;
    }

    public TaxStatementReportSchemaCase06() {
        super("SCHEMA_CASE", 6);
    }
}

