/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSecurityCase03
extends TaxStatementReportCase {
    public static final String IUP = "FLAG_IUP";
    public static final String CONVERSION = "FLAG_CONVERSION";
    public static final String LENDING_FEE = "FLAG_LENDING_FEE";
    public static final String RETROCESSION = "FLAG_RETROCESSION";
    public static final String SECURITIES_LENDING = "FLAG_SECURITIES_LENDING";
    public static final String TAX_CREDIT = "FLAG_TAX_CREDIT";

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    if (category != null) {
                        if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + category);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + category);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double withHoldingTaxClaim = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double withHoldingTaxClaimCalc = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaimCalc(doc, i, j, k);
                    if (!undefined.booleanValue()) {
                        if (grossRevenueA != null || grossRevenueB != null || amount != null || TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc) != null) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (undefined == false));
                        }
                    } else if (grossRevenueA == null && grossRevenueB == null && amount == null && TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc) == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else if (grossRevenueA != null && grossRevenueA == 0.0 && grossRevenueB != null && grossRevenueB == 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else if (grossRevenueA != null && grossRevenueA == 0.0 && grossRevenueB == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else if (grossRevenueB != null && grossRevenueB == 0.0 && grossRevenueA == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(grossRevenueA, TaxStatementReportUtil.nvl(grossRevenueB, TaxStatementReportUtil.nvl(amount, withHoldingTaxClaim)))));
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    if (paymentDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + new SimpleDateFormat("dd.MM.yyyy").format(paymentDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    if (exDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + new SimpleDateFormat("dd.MM.yyyy").format(exDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String name = TaxStatementReportSecurityData.getPaymentName(doc, i, j, k);
                    if (name != null) {
                        if (name.length() >= 0 && name.length() <= 200) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + name);
                        } else if (name.length() > 200) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + name.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 200");
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + name);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String quotationType = TaxStatementReportSecurityData.getPaymentQuotationType(doc, i, j, k);
                    if (quotationType != null) {
                        if (quotationType.equals("PERCENT") || quotationType.equals("PIECE")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + quotationType);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + quotationType);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Double quantity = TaxStatementReportSecurityData.getPaymentQuantity(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    String name = null;
                    int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                    for (int stock = 1; stock <= stocks; ++stock) {
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, stock);
                        if (referenceDate != null && exDate != null && referenceDate.before(exDate)) {
                            name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                            continue;
                        }
                        if (referenceDate == null || paymentDate == null || !referenceDate.before(paymentDate)) continue;
                        name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                    }
                    if (quantity != null) {
                        if (quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", quantity));
                        } else if (category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    if (currency != null) {
                        if (currency.length() == 3 && currency.charAt(0) >= 'A' && currency.charAt(0) <= 'Z' && currency.charAt(1) >= 'A' && currency.charAt(1) <= 'Z' && currency.charAt(2) >= 'A' && currency.charAt(2) <= 'Z') {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + currency);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + currency);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String quotationType = TaxStatementReportSecurityData.getPaymentQuotationType(doc, i, j, k);
                    Double amountPerUnit = TaxStatementReportSecurityData.getPaymentAmountPerUnit(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (amountPerUnit != null) {
                        if (amountPerUnit >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amountPerUnit) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else if (iup != null && iup.booleanValue() && amountPerUnit < 0.0) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + payment + ") " + String.format("%1$,.2f", amountPerUnit) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", amountPerUnit) + (quotationType != null && quotationType.equals("PERCENT") ? "%" : ""));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute12(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(12, this.getStepDescription(lang, 12), this.getStepCondition(lang, 12));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean lumpSumTaxCreditDate = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate));
                    String name = null;
                    int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                    for (int stock = 1; stock <= stocks; ++stock) {
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, stock);
                        if (referenceDate != null && exDate != null && referenceDate.before(exDate)) {
                            name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                            continue;
                        }
                        if (referenceDate == null || paymentDate == null || !referenceDate.before(paymentDate)) continue;
                        name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount < 0.0 && iup.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount < 0.0 && conversion.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount < 0.0 && !lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditDate.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount < 0.0 && category != null && category.equals("SHARE")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount < 0.0 && iup.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount < 0.0 && conversion.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount < 0.0 && !lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditDate.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount < 0.0 && category != null && category.equals("SHARE")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", amount));
                    } else if (currency != null && currency.equals("CHF") && amount == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + currency + " " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute13(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(13, this.getStepDescription(lang, 13), this.getStepCondition(lang, 13));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String quotationType = TaxStatementReportSecurityData.getPaymentQuotationType(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getPaymentQuantity(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amountPerUnit = TaxStatementReportSecurityData.getPaymentAmountPerUnit(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double amountCalc = null;
                    if (quantity != null && amountPerUnit != null) {
                        amountCalc = quotationType != null && quotationType.equals("PERCENT") ? Double.valueOf(quantity * amountPerUnit / 100.0) : Double.valueOf(quantity * amountPerUnit);
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (amount != null && amountCalc != null) {
                        if (String.format("%1$,.2f", amount).equals(String.format("%1$,.2f", amountCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", amount));
                        } else if (TaxStatementReportUtil.approximately(amount, amountCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", amount) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", amountCalc));
                        } else if (TaxStatementReportUtil.approximately(amount, amountCalc, 0.4999999999).booleanValue() && currency != null && (currency.equals("JPY") || currency.equals("TRY"))) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", amount) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", amountCalc));
                        } else if (category != null && (category.equals("OPTION") || category.equals("OTHER")) && amount > amountCalc) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", amount) + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " " + String.format("%1$,.2f", amountCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", amount) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", amountCalc));
                        }
                    } else if (amountCalc != null) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amountCalc));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute14(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(14, this.getStepDescription(lang, 14), this.getStepCondition(lang, 14));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount == 0.0 && exchangeRate == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && amount != null && exchangeRate == null) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR);
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        }
                    } else if (TaxStatementReportProperty.EXCHANGE_RATE) {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute15(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(15, this.getStepDescription(lang, 15), this.getStepCondition(lang, 15));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF") && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.SELECT);
                    } else if (currency != null && currency.equals("CHF")) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportProperty.EXCHANGE_RATE) {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute16(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(16, this.getStepDescription(lang, 16), this.getStepCondition(lang, 16));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double withHoldingTaxClaim = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double withHoldingTaxClaimCalc = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaimCalc(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    String sign = TaxStatementReportSecurityData.getPaymentSign(doc, i, j, k);
                    String name = null;
                    int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                    for (int stock = 1; stock <= stocks; ++stock) {
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, stock);
                        if (referenceDate != null && exDate != null && referenceDate.before(exDate)) {
                            name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                            continue;
                        }
                        if (referenceDate == null || paymentDate == null || !referenceDate.before(paymentDate)) continue;
                        name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                    }
                    if (value != null && value > 0.0 && grossRevenueB != null && grossRevenueB > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", grossRevenueB) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " 0 [B]");
                    } else if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) == 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        if (sign != null && (sign.equals("KEP") || sign.equals("KG") || sign.equals("(KG)") || sign.equals("G") || sign.equals("(G)")) && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (grossRevenueB != null && grossRevenueB != 0.0 && iup.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (grossRevenueB != null && grossRevenueB != 0.0 && conversion.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (currency != null && currency.equals("CHF") && amount != null && !String.format("%1$,.2f", value).equals(String.format("%1$,.2f", amount))) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", amount));
                        } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0 && exchangeRate != null && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", amount) + " * " + String.format("%1$,.5f", exchangeRate));
                        } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0 && value == 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        }
                    } else if (value != null && value < 0.0) {
                        if (grossRevenueB != null && grossRevenueB != 0.0 && iup.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (grossRevenueB != null && grossRevenueB != 0.0 && conversion.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                        }
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0 && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute17(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(17, this.getStepDescription(lang, 17), this.getStepCondition(lang, 17));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double valueCalc = null;
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double withHoldingTaxClaim = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double withHoldingTaxClaimCalc = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaimCalc(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    if (currency != null && !currency.equals("CHF") && amount != null && exchangeRate != null) {
                        valueCalc = amount * exchangeRate;
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (grossRevenueB != null && grossRevenueB != 0.0 && iup.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (grossRevenueB != null && grossRevenueB != 0.0 && conversion.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) == 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF")) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.9999999999).booleanValue() && currency != null && (currency.equals("JPY") || currency.equals("TRY"))) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value != null && valueCalc != null) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (amount != null && amount > 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute18(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(18, this.getStepDescription(lang, 18), this.getStepCondition(lang, 18));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double withHoldingTaxClaim = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double withHoldingTaxClaimCalc = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaimCalc(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    String sign = TaxStatementReportSecurityData.getPaymentSign(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean lumpSumTaxCreditDate = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate));
                    String name = null;
                    int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                    for (int stock = 1; stock <= stocks; ++stock) {
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, stock);
                        if (referenceDate != null && exDate != null && referenceDate.before(exDate)) {
                            name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                            continue;
                        }
                        if (referenceDate == null || paymentDate == null || !referenceDate.before(paymentDate)) continue;
                        name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                    }
                    if (value != null && value > 0.0 && grossRevenueA != null && grossRevenueA > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", grossRevenueA) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " 0 [A]");
                    } else if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) > 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) == 0.0 && TaxStatementReportUtil.nvl(grossRevenueA, 0.0) == 0.0 && TaxStatementReportUtil.nvl(amount, 0.0) == 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        if (sign != null && (sign.equals("KEP") || sign.equals("KG") || sign.equals("(KG)") || sign.equals("G") || sign.equals("(G)")) && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (grossRevenueA != null && grossRevenueA != 0.0 && iup.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (grossRevenueA != null && grossRevenueA != 0.0 && conversion.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (currency != null && currency.equals("CHF") && amount != null && !String.format("%1$,.2f", value).equals(String.format("%1$,.2f", amount))) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", amount));
                        } else if (currency != null && !currency.equals("CHF") && value != null && value == 0.0 && amount != null && amount > 0.0 && exchangeRate != null && exchangeRate > 0.0 && amount * exchangeRate < 0.025) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", amount) + " * " + String.format("%1$,.5f", exchangeRate));
                        } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0 && exchangeRate != null && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", amount) + " * " + String.format("%1$,.5f", exchangeRate));
                        } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0 && value == 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        }
                    } else if (value != null && value < 0.0 && iup.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value < 0.0 && conversion.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value < 0.0 && !lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditDate.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value < 0.0) {
                        if (grossRevenueA != null && grossRevenueA != 0.0 && iup.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (grossRevenueA != null && grossRevenueA != 0.0 && conversion.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                        }
                    } else if (currency != null && currency.equals("CHF") && amount != null && amount > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0 && exchangeRate != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + String.format("%1$,.5f", exchangeRate));
                    } else if (currency != null && !currency.equals("CHF") && amount != null && amount > 0.0) {
                        if (TaxStatementReportProperty.EXCHANGE_RATE) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute19(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(19, this.getStepDescription(lang, 19), this.getStepCondition(lang, 19));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double valueCalc = null;
                    Double withHoldingTaxClaim = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double withHoldingTaxClaimCalc = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaimCalc(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    String sign = TaxStatementReportSecurityData.getPaymentSign(doc, i, j, k);
                    if (currency != null && !currency.equals("CHF") && amount != null && exchangeRate != null) {
                        valueCalc = amount * exchangeRate;
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (grossRevenueA != null && grossRevenueA != 0.0 && iup.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (grossRevenueA != null && grossRevenueA != 0.0 && conversion.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) > 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) == 0.0 && TaxStatementReportUtil.nvl(grossRevenueA, 0.0) == 0.0 && TaxStatementReportUtil.nvl(amount, 0.0) == 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (currency != null && !currency.equals("CHF")) {
                        if (sign != null && (sign.equals("KEP") || sign.equals("KG") || sign.equals("(KG)") || sign.equals("G") || sign.equals("(G)")) && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value != null && valueCalc != null) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (amount != null && amount > 0.0) {
                            if (TaxStatementReportProperty.EXCHANGE_RATE) {
                                entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            } else {
                                entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", amount) + " * " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                            }
                        } else {
                            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute20(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(20, this.getStepDescription(lang, 20), this.getStepCondition(lang, 20));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else if (value != null && value < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute21(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(21, this.getStepDescription(lang, 21), this.getStepCondition(lang, 21));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double valueCalc = null;
                    if (grossRevenueA != null) {
                        valueCalc = grossRevenueA * 0.35;
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (value != null ? String.format("%1$,.2f", value) : TaxStatementReportOperator.UNDEFINED));
                    } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                    } else if (value != null && valueCalc != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                    } else if (value != null && value == 0.0 && valueCalc == null && grossRevenueA == null && grossRevenueB != null) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    } else if (value != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                    } else if (valueCalc != null) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", valueCalc));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute22(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(22, this.getStepDescription(lang, 22), this.getStepCondition(lang, 22));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double lumpSumTaxCreditAmount = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditAmount(doc, i, j, k);
                    Double lumpSumTaxCreditPercent = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditPercent(doc, i, j, k);
                    Double nonRecoverableTaxAmount = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxAmount(doc, i, j, k);
                    Double nonRecoverableTaxPercent = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxPercent(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean lending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!(!lumpSumTaxCredit.booleanValue() || iup.booleanValue() || conversion.booleanValue() || lendingFee.booleanValue() || lending.booleanValue() || retrocession.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else if (lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else if (!lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditAmount != null && lumpSumTaxCreditAmount > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else if (!lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditPercent != null && lumpSumTaxCreditPercent > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else if (!lumpSumTaxCredit.booleanValue() && nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else if (!lumpSumTaxCredit.booleanValue() && nonRecoverableTaxPercent != null && nonRecoverableTaxPercent > 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute23(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(23, this.getStepDescription(lang, 23), this.getStepCondition(lang, 23));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean lending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    Boolean iupSecurity = TaxStatementReportSecurityData.getSecurityIUP(doc, i, j);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!(!iup.booleanValue() || !iupSecurity.booleanValue() || lumpSumTaxCredit.booleanValue() || conversion.booleanValue() || lendingFee.booleanValue() || lending.booleanValue() || retrocession.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, IUP));
                    } else if (!iup.booleanValue() && iupSecurity.booleanValue() || iup.booleanValue() && !iupSecurity.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, IUP) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + iupSecurity);
                    } else if (iup.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, IUP));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute24(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(24, this.getStepDescription(lang, 24), this.getStepCondition(lang, 24));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean lending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!(!conversion.booleanValue() || lumpSumTaxCredit.booleanValue() || iup.booleanValue() || lendingFee.booleanValue() || lending.booleanValue() || retrocession.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, CONVERSION));
                    } else if (conversion.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, CONVERSION));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute25(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(25, this.getStepDescription(lang, 25), this.getStepCondition(lang, 25));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean lending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!(!lendingFee.booleanValue() || lumpSumTaxCredit.booleanValue() || iup.booleanValue() || conversion.booleanValue() || lending.booleanValue() || retrocession.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, LENDING_FEE));
                    } else if (lendingFee.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, LENDING_FEE));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute26(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(26, this.getStepDescription(lang, 26), this.getStepCondition(lang, 26));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean lending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!(!lending.booleanValue() || lumpSumTaxCredit.booleanValue() || iup.booleanValue() || conversion.booleanValue() || lendingFee.booleanValue() || retrocession.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, SECURITIES_LENDING));
                    } else if (lending.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, SECURITIES_LENDING));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute27(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(27, this.getStepDescription(lang, 27), this.getStepCondition(lang, 27));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean lending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!(!retrocession.booleanValue() || lumpSumTaxCredit.booleanValue() || iup.booleanValue() || conversion.booleanValue() || lendingFee.booleanValue() || lending.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, RETROCESSION));
                    } else if (retrocession.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, RETROCESSION));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute28(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(28, this.getStepDescription(lang, 28), this.getStepCondition(lang, 28));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentReductionCost(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, null, null}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentExDate(doc)));
        cs.addStepResultOptional(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentName(doc)));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[10], this.execute10(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[11], this.execute11(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentAmountPerUnit(doc)));
        cs.addStepResultOptional(ok[12], this.execute12(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentAmount(doc)));
        cs.addStepResultOptional(ok[13], this.execute13(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentAmountPerUnit(doc)));
        cs.addStepResultMandatory(ok[14], this.execute14(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentAmountCurrency(doc) && TaxStatementReportSecurityData.getPaymentAmount(doc)));
        cs.addStepResultOptional(ok[15], this.execute15(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentExchangeRate(doc)));
        cs.addStepResultMandatory(ok[16], this.execute16(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[17], this.execute17(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentAmount(doc)));
        cs.addStepResultMandatory(ok[18], this.execute18(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[19], this.execute19(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentAmount(doc)));
        cs.addStepResultMandatory(ok[20], this.execute20(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[21], this.execute21(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[22], this.execute22(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[23], this.execute23(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[24], this.execute24(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[25], this.execute25(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[26], this.execute26(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[27], this.execute27(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[28], this.execute28(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        return cs;
    }

    public TaxStatementReportSecurityCase03() {
        super("SECURITY_CASE", 3);
    }
}

