/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSecurityCase06
extends TaxStatementReportCase {
    public static final String IUP = "FLAG_IUP";
    public static final String CONVERSION = "FLAG_CONVERSION";

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    if (category != null) {
                        if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + category);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + category);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double withHoldingTaxClaim = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double withHoldingTaxClaimCalc = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaimCalc(doc, i, j, k);
                    if (!undefined.booleanValue()) {
                        if (grossRevenueA != null || grossRevenueB != null || amount != null || TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc) != null) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + (undefined == false));
                        }
                    } else if (grossRevenueA == null && grossRevenueB == null && amount == null && TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc) == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else if (grossRevenueA != null && grossRevenueA == 0.0 && grossRevenueB != null && grossRevenueB == 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else if (grossRevenueA != null && grossRevenueA == 0.0 && grossRevenueB == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else if (grossRevenueB != null && grossRevenueB == 0.0 && grossRevenueA == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + (undefined == false));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(grossRevenueA, TaxStatementReportUtil.nvl(grossRevenueB, TaxStatementReportUtil.nvl(amount, withHoldingTaxClaim)))));
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    if (paymentDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + new SimpleDateFormat("dd.MM.yyyy").format(paymentDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    if (exDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + new SimpleDateFormat("dd.MM.yyyy").format(exDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Double quantity = TaxStatementReportSecurityData.getPaymentQuantity(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    String name = null;
                    int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                    for (int stock = 1; stock <= stocks; ++stock) {
                        Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, stock);
                        if (referenceDate != null && exDate != null && referenceDate.before(exDate)) {
                            name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                            continue;
                        }
                        if (referenceDate == null || paymentDate == null || !referenceDate.before(paymentDate)) continue;
                        name = TaxStatementReportSecurityData.getStockName(doc, i, j, stock);
                    }
                    if (quantity != null) {
                        if (quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", quantity));
                        } else if (category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
                    if (category != null && (category.equals("BOND") || category.equals("DEVT"))) {
                        exDate = null;
                    }
                    String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getPaymentQuantity(doc, i, j, k);
                    Double quantityTotal = TaxStatementReportSecurityData.getPaymentQuantityTotal(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate));
                    Double quantityMutation = TaxStatementReportSecurityData.getStockQuantityMutation(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate));
                    Double quantityCalc = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate), iup, conversion);
                    Double quantityBefore = TaxStatementReportSecurityData.getStockQuantityBefore(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate), iup, conversion);
                    Double quantityBeforeII = TaxStatementReportSecurityData.getStockQuantityBefore(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate), iup, conversion, 2);
                    Double quantityBeforeIII = TaxStatementReportSecurityData.getStockQuantityBefore(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate), iup, conversion, 3);
                    Double quantityBeforeIV = TaxStatementReportSecurityData.getStockQuantityBefore(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate), iup, conversion, 4);
                    Double quantityBeforeV = TaxStatementReportSecurityData.getStockQuantityBefore(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate), iup, conversion, 5);
                    Double quantityStock = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, periodFrom);
                    if ((quantityCalc == null || quantityCalc == 0.0) && paymentDate != null && (lendingFee != null && lendingFee.booleanValue() || retrocession != null && retrocession.booleanValue())) {
                        quantityCalc = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, new Date(TaxStatementReportUtil.nvl(exDate, paymentDate).getTime() + 86400L), iup, conversion);
                    }
                    if (quantity != null && quantity >= 0.0 && quantityCalc != null && quantityCalc == 0.0 && (lendingFee.booleanValue() || retrocession.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", quantity));
                    } else if (quantity != null && quantityCalc != null) {
                        if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", quantity));
                        } else if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityBefore)) && exDate == null) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex");
                        } else if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityBeforeII)) && exDate == null) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex(2)");
                        } else if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityBeforeIII)) && exDate == null) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex(3)");
                        } else if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityBeforeIV)) && exDate == null) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex(4)");
                        } else if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityBeforeV)) && exDate == null) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex(5)");
                        } else if (exDate != null && periodFrom != null && exDate.before(periodFrom)) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex(before)");
                        } else if (quantity > 0.0 && quantityCalc == 0.0 && quantityStock != null && quantityStock == 0.0 && exDate == null) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex(0)");
                        } else if (isin != null && isin.length() == 12 && isin.charAt(0) == 'X' && isin.charAt(1) == 'F') {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", quantityCalc) + " ex(xf)");
                        } else if (quantityMutation != null && quantity == -quantityMutation.doubleValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " -(" + String.format("%1$,.2f", quantityMutation) + ")");
                        } else if (quantityTotal != null && String.format("%1$,.2f", quantityCalc).equals(String.format("%1$,.2f", quantityTotal))) {
                            String total = "";
                            int counts = TaxStatementReportSecurityData.getPaymentQuantityCount(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate));
                            for (int c = 0; c < counts; ++c) {
                                if (total.length() > 0) {
                                    total = total + " + ";
                                }
                                total = total + String.format("%1$,.2f", TaxStatementReportSecurityData.getPaymentQuantity(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate), c));
                            }
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", quantityCalc) + " [" + String.format("%1$,.2f", quantity) + "] " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " (" + total + ")");
                        } else if (TaxStatementReportUtil.approximately(quantity, quantityCalc, 4.99999999E-4).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.3f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.3f", quantityCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.3f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.3f", quantityCalc));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", quantity));
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, null}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentExDate(doc)));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        return cs;
    }

    public TaxStatementReportSecurityCase06() {
        super("SECURITY_CASE", 6);
    }
}

