/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSecurityCase07
extends TaxStatementReportCase {
    public static final String TAX_CREDIT = "FLAG_TAX_CREDIT";

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    if (country != null) {
                        if (country.length() == 2 && country.charAt(0) >= 'A' && country.charAt(0) <= 'Z' && country.charAt(1) >= 'A' && country.charAt(1) <= 'Z') {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + country);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + country);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    if (category != null) {
                        if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + category);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + category);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    if (paymentDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + new SimpleDateFormat("dd.MM.yyyy").format(paymentDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    if (exDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + new SimpleDateFormat("dd.MM.yyyy").format(exDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Double withHoldingTaxClaim = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaim(doc, i, j, k);
                    Double withHoldingTaxClaimCalc = TaxStatementReportSecurityData.getPaymentWithHoldingTaxClaimCalc(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Boolean lumpSumTaxCreditDate = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, TaxStatementReportUtil.nvl(exDate, paymentDate));
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) > 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (TaxStatementReportUtil.nvl(TaxStatementReportUtil.nvl(withHoldingTaxClaim, withHoldingTaxClaimCalc), 0.0) == 0.0 && TaxStatementReportUtil.nvl(grossRevenueA, 0.0) == 0.0 && TaxStatementReportUtil.nvl(amount, 0.0) == 0.0 && TaxStatementReportUtil.nvl(value, 0.0) == 0.0) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else if (value != null && value < 0.0 && iup.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value < 0.0 && conversion.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value < 0.0 && !lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditDate.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value < 0.0) {
                        if (grossRevenueA != null && grossRevenueA != 0.0 && iup.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else if (grossRevenueA != null && grossRevenueA != 0.0 && conversion.booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        HashMap<String, Double> nonRecoverables = TaxStatementReportUtil.getDARateNonRecoverable();
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                    String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double lumpSumTaxCreditAmount = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditAmount(doc, i, j, k);
                    Double lumpSumTaxCreditPercent = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditPercent(doc, i, j, k);
                    Double nonRecoverableTaxAmount = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxAmount(doc, i, j, k);
                    Double nonRecoverableTaxPercent = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxPercent(doc, i, j, k);
                    Double additionalWithHoldingTaxUSA = TaxStatementReportSecurityData.getPaymentAdditionalWithHoldingTaxUSA(doc, i, j, k);
                    Boolean iup = TaxStatementReportSecurityData.getPaymentIUP(doc, i, j, k);
                    Boolean conversion = TaxStatementReportSecurityData.getPaymentConversion(doc, i, j, k);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j, k);
                    Boolean lending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, i, j, k);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j, k);
                    String sign = TaxStatementReportSecurityData.getPaymentSign(doc, i, j, k);
                    Boolean lumpSumTaxCreditCalc = false;
                    if (country != null && !country.equals("CH") && category != null && category.equals("SHARE") && valorNumber != null && (valorNumber.equals("1987674") || valorNumber.equals("2165237") || valorNumber.equals("3754629"))) {
                        Double valueNonRecoverable = TaxStatementReportUtil.getDARateNonRecoverable(nonRecoverables, TaxStatementReportUtil.nvl(exDate, paymentDate), country, category, securityType);
                        if (!(grossRevenueB == null || !(grossRevenueB > 0.0) || valueNonRecoverable == null || !(valueNonRecoverable > 0.0) || iup.booleanValue() || conversion.booleanValue() || lendingFee.booleanValue() || lending.booleanValue() || retrocession.booleanValue() || sign != null && (sign == null || sign.equals("(Z)")))) {
                            lumpSumTaxCreditCalc = true;
                            for (int l = 1; l <= payments && lumpSumTaxCreditCalc.booleanValue(); ++l) {
                                if (!TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, l).booleanValue()) continue;
                                lumpSumTaxCreditCalc = false;
                            }
                        }
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + lumpSumTaxCredit);
                    }
                    if (!lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditAmount != null && lumpSumTaxCreditAmount >= 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + lumpSumTaxCreditAmount + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + lumpSumTaxCredit);
                    }
                    if (!lumpSumTaxCredit.booleanValue() && lumpSumTaxCreditPercent != null && lumpSumTaxCreditPercent >= 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + lumpSumTaxCreditPercent + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + lumpSumTaxCredit);
                    }
                    if (!lumpSumTaxCredit.booleanValue() && nonRecoverableTaxAmount != null && nonRecoverableTaxAmount >= 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + nonRecoverableTaxAmount + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + lumpSumTaxCredit);
                    }
                    if (!lumpSumTaxCredit.booleanValue() && nonRecoverableTaxPercent != null && nonRecoverableTaxPercent >= 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + nonRecoverableTaxPercent + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + lumpSumTaxCredit);
                    }
                    if (!lumpSumTaxCredit.booleanValue() && additionalWithHoldingTaxUSA != null && additionalWithHoldingTaxUSA >= 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + additionalWithHoldingTaxUSA + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + lumpSumTaxCredit);
                    } else if (lumpSumTaxCreditCalc.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + lumpSumTaxCredit);
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditPercent(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                    } else if (value != null && value < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10));
        HashMap<String, Double> rates = TaxStatementReportUtil.getDARate();
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditPercent(doc, i, j, k);
                    if (lumpSumTaxCredit.booleanValue() && category != null && category.equals("FUND")) {
                        category = "SHARE";
                        securityType = null;
                    }
                    Double valueRate = TaxStatementReportUtil.getDARate(rates, TaxStatementReportUtil.nvl(exDate, paymentDate), country, category, securityType);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && valueRate != null) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueRate))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportProperty.LUMP_SUM_TAX_CREDIT_PERCENT) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueRate));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueRate));
                        }
                    } else if (value != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditAmount(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else if (value != null && value < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute12(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(12, this.getStepDescription(lang, 12), this.getStepCondition(lang, 12));
        HashMap<String, Double> rates = TaxStatementReportUtil.getDARate();
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double lumpSumTaxCreditPercent = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditPercent(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentLumpSumTaxCreditAmount(doc, i, j, k);
                    Double valueCalc = null;
                    boolean stock = false;
                    if (paymentDate != null) {
                        int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                        for (int s = 1; s <= stocks && !stock; ++s) {
                            Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, s);
                            Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, s);
                            Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, s);
                            if (referenceDate == null || !referenceDate.equals(paymentDate) || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity > 0.0)) continue;
                            stock = true;
                        }
                    }
                    if (lumpSumTaxCredit.booleanValue() && category != null && category.equals("FUND")) {
                        category = "SHARE";
                        securityType = null;
                    }
                    Double valueRate = TaxStatementReportUtil.getDARate(rates, TaxStatementReportUtil.nvl(exDate, paymentDate), country, category, securityType);
                    if (grossRevenueB != null && valueRate != null) {
                        valueCalc = grossRevenueB * valueRate / 100.0;
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (lumpSumTaxCreditPercent == null) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && valueCalc != null) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value < valueCalc && category != null && category.equals("SHARE") && stock) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.SMALLER) + " " + String.format("%1$,.2f", valueCalc) + " (stock)");
                        } else if (TaxStatementReportProperty.LUMP_SUM_TAX_CREDIT_PERCENT) {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        }
                    } else if (value != null) {
                        if (TaxStatementReportProperty.LUMP_SUM_TAX_CREDIT_PERCENT) {
                            entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                        } else {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute13(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(13, this.getStepDescription(lang, 13), this.getStepCondition(lang, 13));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxPercent(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (lumpSumTaxCredit.booleanValue() && value == null) {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else if (value != null && value >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                    } else if (value != null && value < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute14(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(14, this.getStepDescription(lang, 14), this.getStepCondition(lang, 14));
        HashMap<String, Double> nonRecoverables = TaxStatementReportUtil.getDARateNonRecoverable();
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxPercent(doc, i, j, k);
                    if (lumpSumTaxCredit.booleanValue() && category != null && category.equals("FUND")) {
                        category = "SHARE";
                        securityType = null;
                    }
                    Double valueNonRecoverable = TaxStatementReportUtil.getDARateNonRecoverable(nonRecoverables, TaxStatementReportUtil.nvl(exDate, paymentDate), country, category, securityType);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && valueNonRecoverable != null) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueNonRecoverable))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                        } else if (TaxStatementReportUtil.approximately(value, valueNonRecoverable, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                        } else if (value == 0.0 && valueNonRecoverable > 0.0 && !TaxStatementReportUtil.nvl(TaxStatementReportSchemaData.getCountry(doc), "CH").equals("CH")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + "% " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueNonRecoverable) + "%");
                        } else if (value > 0.0 && valueNonRecoverable == 0.0 && category != null && category.equals("BOND")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + "% " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueNonRecoverable) + "%");
                        } else if (value == 15.0 && category != null && category.equals("SHARE") && country != null && country.equals("FR")) {
                            entity.setResult(TaxStatementReportResult.WARNING).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + "% " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueNonRecoverable) + "%");
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + "% " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueNonRecoverable) + "%");
                        }
                    } else if (value != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "% " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(valueNonRecoverable, 0.0)) + "%");
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute15(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(15, this.getStepDescription(lang, 15), this.getStepCondition(lang, 15));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxAmount(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (lumpSumTaxCredit.booleanValue() && value == null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + TaxStatementReportUtil.getText(lang, TAX_CREDIT));
                    } else if (value != null && value >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else if (value != null && value < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute16(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(16, this.getStepDescription(lang, 16), this.getStepCondition(lang, 16));
        HashMap<String, Double> nonRecoverables = TaxStatementReportUtil.getDARateNonRecoverable();
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double percent = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxPercent(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentNonRecoverableTaxAmount(doc, i, j, k);
                    Double valueCalc = null;
                    boolean stock = false;
                    if (paymentDate != null) {
                        int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                        for (int s = 1; s <= stocks && !stock; ++s) {
                            Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, i, j, s);
                            Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, i, j, s);
                            Double quantity = TaxStatementReportSecurityData.getStockQuantity(doc, i, j, s);
                            if (referenceDate == null || !referenceDate.equals(paymentDate) || mutation == null || !mutation.booleanValue() || quantity == null || !(quantity > 0.0)) continue;
                            stock = true;
                        }
                    }
                    if (lumpSumTaxCredit.booleanValue() && category != null && category.equals("FUND")) {
                        category = "SHARE";
                        securityType = null;
                    }
                    Double valueNonRecoverable = TaxStatementReportUtil.getDARateNonRecoverable(nonRecoverables, TaxStatementReportUtil.nvl(exDate, paymentDate), country, category, securityType);
                    if (grossRevenueB != null && valueNonRecoverable != null) {
                        valueCalc = grossRevenueB * valueNonRecoverable / 100.0;
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && valueCalc != null) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value == 0.0 && valueCalc > 0.0 && !TaxStatementReportUtil.nvl(TaxStatementReportSchemaData.getCountry(doc), "CH").equals("CH")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value > 0.0 && valueCalc == 0.0 && category != null && category.equals("BOND")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value < valueCalc && category != null && category.equals("SHARE") && stock) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.SMALLER) + " " + String.format("%1$,.2f", valueCalc) + " (stock)");
                        } else if (percent != null && percent == 15.0 && category != null && category.equals("SHARE") && country != null && country.equals("FR")) {
                            entity.setResult(TaxStatementReportResult.WARNING).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        }
                    } else if (value != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute17(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(17, this.getStepDescription(lang, 17), this.getStepCondition(lang, 17));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentAdditionalWithHoldingTaxUSA(doc, i, j, k);
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (country != null && !country.equals("US")) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && value >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else if (value != null && value < 0.0) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute18(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(18, this.getStepDescription(lang, 18), this.getStepCondition(lang, 18));
        int payment = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                int k = 1;
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                while (k <= payments) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k));
                    String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                    Boolean undefined = TaxStatementReportSecurityData.getPaymentUndefined(doc, i, j, k);
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, i, j, k);
                    Double grossRevenueB = TaxStatementReportSecurityData.getPaymentGrossRevenueB(doc, i, j, k);
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getPaymentAdditionalWithHoldingTaxUSA(doc, i, j, k);
                    Double valueCalc = null;
                    Double valueRate = 15.0;
                    if (grossRevenueB != null && valueRate != null) {
                        valueCalc = grossRevenueB * valueRate / 100.0;
                    }
                    if (undefined.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (!lumpSumTaxCredit.booleanValue()) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (country != null && !country.equals("US")) {
                        entity.setResult(TaxStatementReportResult.IGNORE);
                    } else if (value != null && valueCalc != null) {
                        if (String.format("%1$,.2f", value).equals(String.format("%1$,.2f", valueCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + payment + ") " + String.format("%1$,.2f", value));
                        } else if (TaxStatementReportUtil.approximately(value, valueCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", valueCalc));
                        } else if (value != null && value == 0.0) {
                            entity.setResult(TaxStatementReportResult.WARNING).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + payment + ") " + String.format("%1$,.2f", value) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", valueCalc));
                        }
                    } else if (value != null) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + payment + ") " + String.format("%1$,.2f", value) + "%");
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                    ++k;
                    ++payment;
                }
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, null, null}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentExDate(doc)));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0));
        cs.addStepResultOptional(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultOptional(ok[10], this.execute10(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultOptional(ok[11], this.execute11(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultOptional(ok[12], this.execute12(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultMandatory(ok[13], this.execute13(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultMandatory(ok[14], this.execute14(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultMandatory(ok[15], this.execute15(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultMandatory(ok[16], this.execute16(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc)));
        cs.addStepResultMandatory(ok[17], this.execute17(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc) && TaxStatementReportSecurityData.getSecurityCountryUSA(doc)));
        cs.addStepResultMandatory(ok[18], this.execute18(doc, lang, formula, TaxStatementReportSecurityData.getPaymentCount(doc) > 0 && TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc) && TaxStatementReportSecurityData.getSecurityCountryUSA(doc)));
        return cs;
    }

    public TaxStatementReportSecurityCase07() {
        super("SECURITY_CASE", 7);
    }
}

