/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportTaxStatementData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportTaxStatementCase02
extends TaxStatementReportCase {
    public static final Double LIMIT = 50.0;

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), true, TaxStatementReportTaxStatementData.getTotalGrossRevenueA(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), true, TaxStatementReportTaxStatementData.getTotalGrossRevenueA(doc), formula.calcTotalGrossRevenueA(), formula, LIMIT);
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3), true, TaxStatementReportTaxStatementData.getTotalGrossRevenueA(doc));
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4), filter, TaxStatementReportTaxStatementData.getTotalGrossRevenueACanton(doc));
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5), filter, TaxStatementReportTaxStatementData.getTotalGrossRevenueACanton(doc), formula.calcTotalGrossRevenueACanton(), formula);
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6), filter, TaxStatementReportTaxStatementData.getTotalGrossRevenueACanton(doc));
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7), true, TaxStatementReportTaxStatementData.getTotalWithHoldingTaxClaim(doc));
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        Double total = TaxStatementReportTaxStatementData.getTotalWithHoldingTaxClaim(doc);
        Double calc = formula.calcTotalWithHoldingTaxClaim();
        if (total != null && calc != null) {
            if (String.format("%1$,.2f", total).equals(String.format("%1$,.2f", calc))) {
                entity.setResult(TaxStatementReportResult.OK).setRemark(String.format("%1$,.2f", total));
            } else if (TaxStatementReportUtil.approximately(total, calc).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", calc));
            } else if (formula.approximately(total, calc).booleanValue()) {
                entity.setResult(TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", calc));
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", calc));
            }
        } else if (total != null) {
            entity.setResult(TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9), true, TaxStatementReportTaxStatementData.getTotalWithHoldingTaxClaim(doc));
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10), false, formula.calcGrossRevenueA());
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK}, {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultMandatory(ok[2], this.execute02(doc, lang, formula));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportTaxStatementData.getTotalGrossRevenueACanton(doc) != null));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportTaxStatementData.getTotalGrossRevenueACanton(doc) != null));
        cs.addStepResultMandatory(ok[6], this.execute06(doc, lang, formula, TaxStatementReportTaxStatementData.getTotalGrossRevenueACanton(doc) != null));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportTaxStatementData.getTotalWithHoldingTaxClaim(doc) != null));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula));
        cs.addStepResultOptional(ok[10], this.execute10(doc, lang, formula));
        return cs;
    }

    public TaxStatementReportTaxStatementCase02() {
        super("TAX_STATEMENT_CASE", 2);
    }
}

