/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportTaxStatementCase09
extends TaxStatementReportCase {
    public static final Double LIMIT = 400.0;

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3), filter, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4), filter, TaxStatementReportSecurityData.getTotalTaxValue(doc), formula.calcTotalSecurityTaxValue(), formula, LIMIT);
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5), filter, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6), filter, formula.calcTotalSecurityTaxValueOther());
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        Double total = TaxStatementReportSecurityData.getTotalTaxValue(doc);
        Double calc = formula.calcTotalSecurityTaxValue();
        Double other = formula.calcTotalSecurityTaxValueOther();
        if (total != null && calc != null && calc > 0.0 && other != null && other > 0.0) {
            if (String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.2f", calc))) {
                entity.setResult(TaxStatementReportResult.OK);
            } else if (TaxStatementReportUtil.approximately(total, calc).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK);
            } else if (String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.2f", calc + other))) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", calc) + " + " + String.format("%1$,.2f", other));
            } else if (TaxStatementReportUtil.approximately(total, calc + other).booleanValue()) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", calc) + " + " + String.format("%1$,.2f", other));
            } else {
                entity.setResult(TaxStatementReportResult.OK);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.OK : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && formula.calcTotalSecurityTaxValueOther() != null));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, formula.calcTotalSecurityTaxValueOther() != null));
        return cs;
    }

    public TaxStatementReportTaxStatementCase09() {
        super("TAX_STATEMENT_CASE", 9);
    }
}

