/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportTaxStatementCase11
extends TaxStatementReportCase {
    public static final Double LIMIT = 50.0;

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3), filter, TaxStatementReportSecurityData.getTotalGrossRevenueB(doc));
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4), filter, TaxStatementReportSecurityData.getTotalGrossRevenueB(doc), formula.calcTotalSecurityGrossRevenueB(), formula, LIMIT);
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5), filter, TaxStatementReportSecurityData.getTotalGrossRevenueB(doc));
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6), filter, TaxStatementReportSecurityData.getTotalGrossRevenueBCanton(doc));
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7), filter, TaxStatementReportSecurityData.getTotalGrossRevenueBCanton(doc), formula.calcTotalSecurityGrossRevenueBCanton(), formula);
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8), filter, TaxStatementReportSecurityData.getTotalGrossRevenueBCanton(doc));
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9), filter, formula.calcTotalSecurityGrossRevenueBIUPPositive());
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10), filter, formula.calcTotalSecurityGrossRevenueBIUPNegative());
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11), filter, formula.calcTotalSecurityGrossRevenueBRetrocession());
    }

    protected TaxStatementReportResultStep execute12(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(12, this.getStepDescription(lang, 12), this.getStepCondition(lang, 12), filter, formula.calcTotalSecurityGrossRevenueBSecuritiesLending());
    }

    protected TaxStatementReportResultStep execute13(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(13, this.getStepDescription(lang, 13), this.getStepCondition(lang, 13));
        Double total = TaxStatementReportSecurityData.getTotalGrossRevenueB(doc);
        Double calc = formula.calcTotalSecurityGrossRevenueB();
        Double iup = formula.calcTotalSecurityGrossRevenueBIUPNegative();
        Double retro = formula.calcTotalSecurityGrossRevenueBRetrocession();
        Double lending = formula.calcTotalSecurityGrossRevenueBSecuritiesLending();
        if (total != null && calc != null && calc > 0.0 && (iup != null && iup < 0.0 || retro != null && retro > 0.0 || lending != null && lending > 0.0)) {
            if (String.format("%1$,.2f", total).equals(String.format("%1$,.2f", calc))) {
                entity.setResult(TaxStatementReportResult.OK).setRemark(String.format("%1$,.2f", total));
            } else if (TaxStatementReportUtil.approximately(total, calc).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", calc));
            } else if (String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.2f", calc + TaxStatementReportUtil.nvl(iup, 0.0) + TaxStatementReportUtil.nvl(retro, 0.0) + TaxStatementReportUtil.nvl(lending, 0.0)))) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.EQUAL) + " " + String.format("%1$,.2f", calc) + " - " + String.format("%1$,.2f", -TaxStatementReportUtil.nvl(iup, 0.0).doubleValue()) + " + " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(retro, 0.0)) + " + " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(lending, 0.0)));
            } else if (TaxStatementReportUtil.approximately(total, calc + TaxStatementReportUtil.nvl(iup, 0.0) + TaxStatementReportUtil.nvl(retro, 0.0) + TaxStatementReportUtil.nvl(lending, 0.0)).booleanValue()) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", calc) + " - " + String.format("%1$,.2f", -TaxStatementReportUtil.nvl(iup, 0.0).doubleValue()) + " + " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(retro, 0.0)) + " + " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(lending, 0.0)));
            } else {
                entity.setResult(TaxStatementReportResult.OK).setRemark(String.format("%1$,.2f", total));
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.OK : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalGrossRevenueB(doc) != null));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalGrossRevenueB(doc) != null));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalGrossRevenueBCanton(doc) != null));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getTotalGrossRevenueBCanton(doc) != null));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getTotalGrossRevenueBCanton(doc) != null));
        cs.addStepResultOptional(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && formula.calcTotalSecurityGrossRevenueBIUPPositive() != null));
        cs.addStepResultOptional(ok[10], this.execute10(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && formula.calcTotalSecurityGrossRevenueBIUPNegative() != null));
        cs.addStepResultOptional(ok[11], this.execute11(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && formula.calcTotalSecurityGrossRevenueBRetrocession() != null));
        cs.addStepResultOptional(ok[12], this.execute12(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && formula.calcTotalSecurityGrossRevenueBSecuritiesLending() != null));
        cs.addStepResultMandatory(ok[13], this.execute13(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && (formula.calcTotalSecurityGrossRevenueBIUPNegative() != null || formula.calcTotalSecurityGrossRevenueBRetrocession() != null || formula.calcTotalSecurityGrossRevenueBSecuritiesLending() != null)));
        return cs;
    }

    public TaxStatementReportTaxStatementCase11() {
        super("TAX_STATEMENT_CASE", 11);
    }
}

