/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportExpenseData;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportTaxStatementCase15
extends TaxStatementReportCase {
    public static final Double LIMIT = 50.0;

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportExpenseData.getTotalExpenses(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportExpenseData.getExpenseCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3), filter, TaxStatementReportExpenseData.getTotalExpenses(doc));
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4), filter, TaxStatementReportExpenseData.getTotalExpenses(doc), formula.calcTotalExpenses(), formula, LIMIT);
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5), filter, TaxStatementReportExpenseData.getTotalExpenses(doc));
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6), filter, TaxStatementReportExpenseData.getTotalExpensesDeductible(doc));
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7), filter, TaxStatementReportExpenseData.getTotalExpensesDeductible(doc), formula.calcTotalExpensesDeductible(), formula);
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8), filter, TaxStatementReportExpenseData.getTotalExpensesDeductible(doc));
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9), filter, TaxStatementReportExpenseData.getTotalExpensesDeductibleCanton(doc));
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10), filter, TaxStatementReportExpenseData.getTotalExpensesDeductibleCanton(doc), formula.calcTotalExpensesDeductibleCanton(), formula);
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11), filter, TaxStatementReportExpenseData.getTotalExpensesDeductibleCanton(doc));
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportExpenseData.getTotalExpenses(doc) != null && TaxStatementReportExpenseData.getExpenseCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportExpenseData.getTotalExpenses(doc) != null));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportExpenseData.getExpenseCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportExpenseData.getTotalExpenses(doc) != null));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportExpenseData.getTotalExpenses(doc) != null && TaxStatementReportExpenseData.getTotalExpensesDeductible(doc) != null));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportExpenseData.getExpenseCount(doc) > 0 && TaxStatementReportExpenseData.getTotalExpensesDeductible(doc) != null));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportExpenseData.getTotalExpenses(doc) != null && TaxStatementReportExpenseData.getTotalExpensesDeductible(doc) != null));
        cs.addStepResultOptional(ok[9], this.execute09(doc, lang, formula, TaxStatementReportExpenseData.getTotalExpenses(doc) != null && TaxStatementReportExpenseData.getTotalExpensesDeductibleCanton(doc) != null));
        cs.addStepResultMandatory(ok[10], this.execute10(doc, lang, formula, TaxStatementReportExpenseData.getExpenseCount(doc) > 0 && TaxStatementReportExpenseData.getTotalExpensesDeductibleCanton(doc) != null));
        cs.addStepResultMandatory(ok[11], this.execute11(doc, lang, formula, TaxStatementReportExpenseData.getTotalExpenses(doc) != null && TaxStatementReportExpenseData.getTotalExpensesDeductibleCanton(doc) != null));
        return cs;
    }

    public TaxStatementReportTaxStatementCase15() {
        super("TAX_STATEMENT_CASE", 15);
    }
}

