/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report.csv;

import ch.ewv.taxstatement.report.TaxStatementReport;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultList;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportCSV
extends TaxStatementReport {
    protected String included(String result, String level) {
        String included = null;
        if (result != null && level != null && (!result.equals("FATAL") || level.equals("FATAL") || level.equals("ERROR") || level.equals("WARNING") || level.equals("OK")) && (!result.equals("ERROR") || level.equals("ERROR") || level.equals("WARNING") || level.equals("OK")) && (!result.equals("WARNING") || level.equals("WARNING") || level.equals("OK")) && (!result.equals("OK") || level.equals("OK"))) {
            included = result;
        }
        return included;
    }

    protected String result(TaxStatementReportResult result) {
        String str = null;
        if (result != null) {
            if (result == TaxStatementReportResult.ERROR || result == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || result == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
                str = "ERROR";
            } else if (result == TaxStatementReportResult.FATAL) {
                str = "FATAL";
            } else if (result == TaxStatementReportResult.OK || result == TaxStatementReportResult.IGNORE || result == TaxStatementReportResult.SELECT) {
                str = "OK";
            } else if (result == TaxStatementReportResult.WARNING) {
                str = "WARNING";
            }
        }
        return str;
    }

    protected String summary() {
        String summary = null;
        if (this.getResultList() != null) {
            TaxStatementReportResult result = this.getResultList().getResult();
            summary = result != null && (result == TaxStatementReportResult.OK || result == TaxStatementReportResult.IGNORE || result == TaxStatementReportResult.WARNING && !TaxStatementReportProperty.SSK) ? "APPROVED" : "NOT APPROVED";
        }
        return summary;
    }

    protected String errorType(TaxStatementReportResultEntity entity) {
        return entity != null ? this.result(entity.getResult()) : null;
    }

    protected String errorType(TaxStatementReportResultEntity entity, String level) {
        return this.included(this.errorType(entity), level);
    }

    protected String errorArea(TaxStatementReportResultCase cs) {
        String area = null;
        if (cs != null && cs.getCaseGroup() != null) {
            if (cs.getCaseGroup().equals("BANK_ACCOUNT_CASE")) {
                area = "BANKACCOUNT";
            } else if (cs.getCaseGroup().equals("CLIENT_CASE")) {
                area = "CLIENT";
            } else if (cs.getCaseGroup().equals("EXPENSE_CASE")) {
                area = "EXPENSE";
            } else if (cs.getCaseGroup().equals("INSTITUTION_CASE")) {
                area = "INSTITUTION";
            } else if (cs.getCaseGroup().equals("LIABILITY_ACCOUNT_CASE")) {
                area = "LIABILITY";
            } else if (cs.getCaseGroup().equals("SCHEMA_CASE")) {
                area = "SCHEMA";
            } else if (cs.getCaseGroup().equals("SECURITY_CASE")) {
                area = "SECURITY";
            } else if (cs.getCaseGroup().equals("TAX_STATEMENT_CASE")) {
                area = "TAXSTATEMENT";
            }
        }
        return area;
    }

    protected String testCase(TaxStatementReportResultCase cs) {
        String tc = null;
        if (cs != null && cs.getCaseGroup() != null) {
            if (cs.getCaseGroup().equals("BANK_ACCOUNT_CASE")) {
                tc = "BANKAC";
            } else if (cs.getCaseGroup().equals("CLIENT_CASE")) {
                tc = "CLIENT";
            } else if (cs.getCaseGroup().equals("EXPENSE_CASE")) {
                tc = "EXPENSE";
            } else if (cs.getCaseGroup().equals("INSTITUTION_CASE")) {
                tc = "INSTITUT";
            } else if (cs.getCaseGroup().equals("LIABILITY_ACCOUNT_CASE")) {
                tc = "LIABILITY";
            } else if (cs.getCaseGroup().equals("SCHEMA_CASE")) {
                tc = "SCHEMA";
            } else if (cs.getCaseGroup().equals("SECURITY_CASE")) {
                tc = "SECURITY";
            } else if (cs.getCaseGroup().equals("TAX_STATEMENT_CASE")) {
                tc = "TAXSTA";
            }
            tc = tc + "-" + String.format("%02d", cs.getCaseId());
        }
        return tc;
    }

    protected String testStep(TaxStatementReportResultStep step, TaxStatementReportResultCase cs) {
        return step != null && cs != null ? this.testCase(cs) + "-" + String.format("%02d", step.getStepId()) : null;
    }

    protected String testDescription(TaxStatementReportResultStep step) {
        return step != null ? step.getDescription() : null;
    }

    protected String reason(TaxStatementReportResultEntity entity) {
        String reason = "";
        if (entity != null && entity.getReason() != null) {
            reason = entity.getReason().replace(";", "").replace("\r\n", " ").replace("\r", " ").replace("\n", " ").replace(TaxStatementReportOperator.APPROXIMATELY.toString(), "~").replace(TaxStatementReportOperator.NOTEQUAL.toString(), "!=").replace(TaxStatementReportOperator.NOTGREATER.toString(), "!>").replace(TaxStatementReportOperator.NOTGREATEREQUAL.toString(), "!>=").replace(TaxStatementReportOperator.NOTSMALLER.toString(), "!<").replace(TaxStatementReportOperator.NOTSMALLEREQUAL.toString(), "!<=");
        }
        return reason;
    }

    protected String asset(TaxStatementReportResultEntity entity) {
        String asset = "";
        if (entity != null && entity.getAsset() != null) {
            asset = entity.getAsset().replace(";", "").replace("\r\n", " ").replace("\r", " ").replace("\n", " ");
        }
        return asset;
    }

    protected String date(TaxStatementReportResultEntity entity) {
        String date = "";
        if (entity != null && entity.getReferenceDate() != null) {
            date = new SimpleDateFormat("dd.MM.yyyy").format(entity.getReferenceDate());
        }
        return date;
    }

    protected List<String> result(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("FILE_NAME;SUMMARY;ERROR TYPE;ERROR AREA;TEST CASE;TEST STEP;TEST DESCRIPTION;RESULT;ASSET;DATE");
        if (this.getResultList() != null && this.getResultList().getCases() != null) {
            String summary = this.summary();
            for (TaxStatementReportResultCase cs : this.getResultList().getCases()) {
                String errorArea = this.errorArea(cs);
                String testCase = this.testCase(cs);
                if (cs == null || cs.getSteps() == null) continue;
                for (TaxStatementReportResultStep step : cs.getSteps()) {
                    String testStep = this.testStep(step, cs);
                    String testDescription = this.testDescription(step);
                    if (step.getEntities() == null) continue;
                    for (TaxStatementReportResultEntity entity : step.getEntities()) {
                        String errorType = this.errorType(entity, TaxStatementReportProperty.LOGGING_LEVEL);
                        String reason = this.reason(entity);
                        String asset = this.asset(entity);
                        String date = this.date(entity);
                        if (summary == null || errorType == null || errorArea == null || testCase == null || testStep == null || testDescription == null) continue;
                        list.add(name + ";" + summary + ";" + errorType + ";" + errorArea + ";" + testCase + ";" + testStep + ";" + testDescription + ";" + reason + ";" + asset + ";" + date);
                    }
                }
            }
        }
        return list;
    }

    public List<String> result() {
        return this.result(this.getSource());
    }

    @Override
    protected void save(String name) throws IOException {
        if (name != null && (name.endsWith(".csv") || name.endsWith(".pdf") || name.endsWith(".xlsx") || name.endsWith(".xml"))) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(name.replace(".pdf", ".csv").replace(".xlsx", ".csv").replace(".xml", ".csv")));
            for (String line : this.result()) {
                if (line == null) continue;
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
    }

    @Override
    protected void translate(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula, TaxStatementReportResultList result) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
    }

    public TaxStatementReportCSV() {
    }

    public TaxStatementReportCSV(String[] args) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.translate(args);
    }
}

