/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report.ssk;

import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class TaxStatementReportSSKEntity {
    public static final String HEADER_CONDITION = "HEADER_CONDITION";
    public static final String HEADER_DESCRIPTION = "HEADER_DESCRIPTION";
    public static final String HEADER_NAME = "HEADER_NAME";
    public static final String HEADER_REQUIRED = "HEADER_REQUIRED";
    public static final String HEADER_RESULT = "HEADER_RESULT";
    public static final String HEADER_RESULT_OK = "HEADER_RESULT_OK";
    public static final String HEADER_RESULTS = "HEADER_RESULTS";
    public static final String OF = "OF";
    public static final String PAGE = "PAGE";
    public static final String LEGEND_NAME = "LEGEND_NAME";
    public static final String LEGEND_APPROXIMATELY = "LEGEND_APPROXIMATELY";
    public static final String LEGEND_ERROR = "LEGEND_ERROR";
    public static final String LEGEND_FATAL = "LEGEND_FATAL";
    public static final String LEGEND_OK = "LEGEND_OK";
    public static final String LEGEND_SELECT = "LEGEND_SELECT";
    public static final String LEGEND_WARNING = "LEGEND_WARNING";
    public static final String LEGEND_IGNORE = "LEGEND_IGNORE";
    public static final String LEGEND_MANDATORY = "LEGEND_MANDATORY";
    public static final String LEGEND_GREATER = "LEGEND_GREATER";
    public static final String LEGEND_SMALLER = "LEGEND_SMALLER";
    public static final String LEGEND_NOTEQUAL = "LEGEND_NOTEQUAL";
    public static final String LEGEND_NOTGREATER = "LEGEND_NOTGREATER";
    public static final String LEGEND_NOTGREATEREQUAL = "LEGEND_NOTGREATEREQUAL";
    public static final String LEGEND_NOTSMALLER = "LEGEND_NOTSMALLER";
    public static final String LEGEND_NOTSMALLEREQUAL = "LEGEND_NOTSMALLEREQUAL";
    private static final int DEFAULT_WIDTH = 12;
    private int resultOK;
    private List<TaxStatementReportResultCase> cases;
    private Font fth;
    private Font fthx;
    private Font fthg;
    private Font fthr;
    private Font fthb;
    private Font fthy;
    private Font fthv;
    private Font fts;
    private Font ftw;
    private Font ftwg;
    private Font ftwr;
    private Font ftwb;
    private Font ftwy;
    private Font ftwv;
    private CellStyle csh;
    private CellStyle cshc;
    private CellStyle css;
    private CellStyle cssc;
    private CellStyle csw;
    private CellStyle cswg;
    private CellStyle cswr;
    private CellStyle cswb;
    private CellStyle cswy;
    private CellStyle cswv;
    private CellStyle cswbx;
    private CellStyle cswbg;
    private CellStyle cswbr;
    private CellStyle cswbb;
    private CellStyle cswby;
    private CellStyle cswbv;
    private boolean legendError = true;
    private boolean legendFatal = false;
    private boolean legendIgnore = true;
    private boolean legendMandatory = true;
    private boolean legendOK = true;
    private boolean legendSelect = false;
    private boolean legendWarning = false;
    private boolean legendApproximately = false;
    private boolean legendGreater = false;
    private boolean legendSmaller = false;
    private boolean legendNotEqual = false;
    private boolean legendNotGreater = false;
    private boolean legendNotGreaterEqual = false;
    private boolean legendNotSmaller = false;
    private boolean legendNotSmallerEqual = false;

    protected int getResultOK() {
        return this.resultOK;
    }

    protected void setResultOK(int resultOK) {
        this.resultOK = resultOK;
    }

    protected List<TaxStatementReportResultCase> getCases() {
        return this.cases;
    }

    protected void setCases(List<TaxStatementReportResultCase> cases) {
        this.cases = cases;
    }

    protected void initFont(Workbook wb) {
        this.fth = wb.createFont();
        this.fthx = wb.createFont();
        this.fthg = wb.createFont();
        this.fthr = wb.createFont();
        this.fthb = wb.createFont();
        this.fthy = wb.createFont();
        this.fthv = wb.createFont();
        this.fts = wb.createFont();
        this.ftw = wb.createFont();
        this.ftwg = wb.createFont();
        this.ftwr = wb.createFont();
        this.ftwb = wb.createFont();
        this.ftwy = wb.createFont();
        this.ftwv = wb.createFont();
        this.fth.setFontName("Calibri");
        this.fth.setFontHeightInPoints((short)11);
        this.fth.setBold(true);
        this.fthx.setFontName("Wingdings");
        this.fthx.setFontHeightInPoints((short)15);
        this.fthx.setBold(true);
        this.fthg.setFontName("Wingdings");
        this.fthg.setFontHeightInPoints((short)15);
        this.fthg.setColor(IndexedColors.GREEN.index);
        this.fthg.setBold(true);
        this.fthr.setFontName("Wingdings");
        this.fthr.setFontHeightInPoints((short)15);
        this.fthr.setColor(IndexedColors.RED.index);
        this.fthr.setBold(true);
        this.fthb.setFontName("Wingdings");
        this.fthb.setFontHeightInPoints((short)15);
        this.fthb.setColor(IndexedColors.ROYAL_BLUE.index);
        this.fthb.setBold(true);
        this.fthy.setFontName("Wingdings");
        this.fthy.setFontHeightInPoints((short)15);
        this.fthy.setColor(IndexedColors.YELLOW.index);
        this.fthy.setBold(true);
        this.fthv.setFontName("Wingdings");
        this.fthv.setFontHeightInPoints((short)15);
        this.fthv.setColor(IndexedColors.PINK.index);
        this.fthv.setBold(true);
        this.fts.setFontName("Calibri");
        this.fts.setFontHeightInPoints((short)11);
        this.ftw.setFontName("Wingdings");
        this.ftw.setFontHeightInPoints((short)11);
        this.ftwg.setFontName("Wingdings");
        this.ftwg.setFontHeightInPoints((short)11);
        this.ftwg.setColor(IndexedColors.GREEN.index);
        this.ftwr.setFontName("Wingdings");
        this.ftwr.setFontHeightInPoints((short)11);
        this.ftwr.setColor(IndexedColors.RED.index);
        this.ftwb.setFontName("Wingdings");
        this.ftwb.setFontHeightInPoints((short)11);
        this.ftwb.setColor(IndexedColors.ROYAL_BLUE.index);
        this.ftwy.setFontName("Wingdings");
        this.ftwy.setFontHeightInPoints((short)11);
        this.ftwy.setColor(IndexedColors.YELLOW.index);
        this.ftwv.setFontName("Wingdings");
        this.ftwv.setFontHeightInPoints((short)11);
        this.ftwv.setColor(IndexedColors.PINK.index);
    }

    protected void initStyle(Workbook wb) {
        this.csh = wb.createCellStyle();
        this.cshc = wb.createCellStyle();
        this.css = wb.createCellStyle();
        this.cssc = wb.createCellStyle();
        this.csw = wb.createCellStyle();
        this.cswg = wb.createCellStyle();
        this.cswr = wb.createCellStyle();
        this.cswb = wb.createCellStyle();
        this.cswy = wb.createCellStyle();
        this.cswv = wb.createCellStyle();
        this.cswbx = wb.createCellStyle();
        this.cswbg = wb.createCellStyle();
        this.cswbr = wb.createCellStyle();
        this.cswbb = wb.createCellStyle();
        this.cswby = wb.createCellStyle();
        this.cswbv = wb.createCellStyle();
        this.csh.setFont(this.fth);
        this.csh.setAlignment(HorizontalAlignment.LEFT);
        this.csh.setVerticalAlignment(VerticalAlignment.TOP);
        this.csh.setWrapText(true);
        this.cshc.setFont(this.fth);
        this.cshc.setAlignment(HorizontalAlignment.CENTER);
        this.cshc.setVerticalAlignment(VerticalAlignment.TOP);
        this.cshc.setWrapText(true);
        this.css.setFont(this.fts);
        this.css.setAlignment(HorizontalAlignment.LEFT);
        this.css.setVerticalAlignment(VerticalAlignment.TOP);
        this.css.setWrapText(true);
        this.cssc.setFont(this.fts);
        this.cssc.setAlignment(HorizontalAlignment.CENTER);
        this.cssc.setVerticalAlignment(VerticalAlignment.TOP);
        this.cssc.setWrapText(true);
        this.csw.setFont(this.ftw);
        this.csw.setAlignment(HorizontalAlignment.CENTER);
        this.csw.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswg.setFont(this.ftwg);
        this.cswg.setAlignment(HorizontalAlignment.CENTER);
        this.cswg.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswr.setFont(this.ftwr);
        this.cswr.setAlignment(HorizontalAlignment.CENTER);
        this.cswr.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswb.setFont(this.ftwb);
        this.cswb.setAlignment(HorizontalAlignment.CENTER);
        this.cswb.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswy.setFont(this.ftwy);
        this.cswy.setAlignment(HorizontalAlignment.CENTER);
        this.cswy.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswv.setFont(this.ftwv);
        this.cswv.setAlignment(HorizontalAlignment.CENTER);
        this.cswv.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswbx.setFont(this.fthx);
        this.cswbx.setAlignment(HorizontalAlignment.CENTER);
        this.cswbx.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswbx.setBorderTop(BorderStyle.THIN);
        this.cswbx.setBorderBottom(BorderStyle.DOUBLE);
        this.cswbg.setFont(this.fthg);
        this.cswbg.setAlignment(HorizontalAlignment.CENTER);
        this.cswbg.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswbg.setBorderTop(BorderStyle.THIN);
        this.cswbg.setBorderBottom(BorderStyle.DOUBLE);
        this.cswbr.setFont(this.fthr);
        this.cswbr.setAlignment(HorizontalAlignment.CENTER);
        this.cswbr.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswbr.setBorderTop(BorderStyle.THIN);
        this.cswbr.setBorderBottom(BorderStyle.DOUBLE);
        this.cswbb.setFont(this.fthb);
        this.cswbb.setAlignment(HorizontalAlignment.CENTER);
        this.cswbb.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswbb.setBorderTop(BorderStyle.THIN);
        this.cswbb.setBorderBottom(BorderStyle.DOUBLE);
        this.cswby.setFont(this.fthy);
        this.cswby.setAlignment(HorizontalAlignment.CENTER);
        this.cswby.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswby.setBorderTop(BorderStyle.THIN);
        this.cswby.setBorderBottom(BorderStyle.DOUBLE);
        this.cswbv.setFont(this.fthv);
        this.cswbv.setAlignment(HorizontalAlignment.CENTER);
        this.cswbv.setVerticalAlignment(VerticalAlignment.CENTER);
        this.cswbv.setBorderTop(BorderStyle.THIN);
        this.cswbv.setBorderBottom(BorderStyle.DOUBLE);
    }

    protected void initSheet(Workbook wb, Properties lang, String sheet) {
        TaxStatementReportUtil.addSheet(wb, TaxStatementReportUtil.getText(lang, sheet));
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, HEADER_NAME));
        TaxStatementReportUtil.setWidth(wb, 14);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, HEADER_DESCRIPTION));
        TaxStatementReportUtil.setWidth(wb, 43);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, HEADER_CONDITION));
        TaxStatementReportUtil.setWidth(wb, 20);
        TaxStatementReportUtil.setHidden(wb, true);
        TaxStatementReportUtil.addCell(wb, this.cshc, TaxStatementReportUtil.getText(lang, HEADER_REQUIRED));
        TaxStatementReportUtil.setWidth(wb, 9);
        TaxStatementReportUtil.setHidden(wb, true);
        int resultOK = this.getResultOK();
        for (int i = 0; i < resultOK; ++i) {
            TaxStatementReportUtil.addCell(wb, this.cshc, i == 0 ? TaxStatementReportUtil.getText(lang, HEADER_RESULT_OK) : "");
            TaxStatementReportUtil.setHidden(wb, true);
            if (this.getResultOK() >= 4) {
                TaxStatementReportUtil.setWidth(wb, 2);
                continue;
            }
            if (this.getResultOK() == 3) {
                TaxStatementReportUtil.setWidth(wb, 3);
                continue;
            }
            if (this.getResultOK() == 2) {
                TaxStatementReportUtil.setWidth(wb, 4);
                continue;
            }
            if (this.getResultOK() != 1) continue;
            TaxStatementReportUtil.setWidth(wb, 8);
        }
        if (resultOK > 1) {
            TaxStatementReportUtil.getSheet(wb).addMergedRegion(new CellRangeAddress(TaxStatementReportUtil.getNumberOfRows(wb) - 1, TaxStatementReportUtil.getNumberOfRows(wb) - 1, 4, 3 + resultOK));
        }
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, HEADER_RESULTS));
        TaxStatementReportUtil.setWidth(wb, 33);
        TaxStatementReportUtil.addCell(wb, this.cshc, TaxStatementReportUtil.getText(lang, HEADER_RESULT));
        TaxStatementReportUtil.setWidth(wb, 9);
        TaxStatementReportUtil.getSheet(wb).createFreezePane(0, 1);
        TaxStatementReportUtil.getSheet(wb).setFitToPage(true);
        TaxStatementReportUtil.getSheet(wb).setDisplayGridlines(true);
        TaxStatementReportUtil.getSheet(wb).setPrintGridlines(true);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.TOP, 0.5);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.BOTTOM, 0.5);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.LEFT, 0.3);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.RIGHT, 0.3);
        TaxStatementReportUtil.getSheet(wb).getHeader().setCenter(TaxStatementReportUtil.getSheet(wb).getSheetName());
        TaxStatementReportUtil.getSheet(wb).getFooter().setCenter(TaxStatementReportUtil.getText(lang, PAGE) + " &P " + TaxStatementReportUtil.getText(lang, OF) + " &N");
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setPaperSize((short)9);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setLandscape(false);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFitWidth((short)1);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFitHeight((short)0);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setHeaderMargin(0.2);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFooterMargin(0.3);
    }

    /*
     * WARNING - void declaration
     */
    protected void addCase(TaxStatementReportResultCase cs, Workbook wb, Properties lang) {
        void var9_21;
        void var9_13;
        int firstRow = TaxStatementReportUtil.getNumberOfRows(wb);
        this.getCases().add(cs);
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.csh, cs.getName());
        TaxStatementReportUtil.addCell(wb, this.csh, cs.getDescription());
        TaxStatementReportUtil.addCell(wb, this.csh);
        TaxStatementReportUtil.addCell(wb, this.csh);
        int resultOK = this.getResultOK();
        for (int i = 0; i < resultOK; ++i) {
            TaxStatementReportUtil.addCell(wb, this.csh);
        }
        TaxStatementReportUtil.addCell(wb, this.csh);
        TaxStatementReportUtil.addCell(wb, this.csh);
        List<Integer> indexesERROR = cs.getIndexesERROR();
        List<String> entities = cs.getEntities();
        for (Integer n : indexesERROR) {
            String entity = entities.get(n);
            if (entity == null || entity.length() <= 0) continue;
            if (indexesERROR.indexOf(n) == 0) {
                TaxStatementReportUtil.addCell(wb, this.csh);
                TaxStatementReportUtil.setWidth(wb, 1);
            }
            TaxStatementReportUtil.addCell(wb, this.csh, "(" + (n + 1) + ")" + entity);
            if (entity.length() <= 8) continue;
            TaxStatementReportUtil.setHeight(wb, 2.3);
        }
        List<TaxStatementReportResultStep> steps = cs.getSteps();
        for (TaxStatementReportResultStep step : steps) {
            CellStyle cx = this.css;
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.css, cs.getName() + "-" + (steps.indexOf(step) + 1));
            TaxStatementReportUtil.addCell(wb, this.css, step.getDescription());
            TaxStatementReportUtil.addCell(wb, this.css, step.getCondition());
            TaxStatementReportUtil.addCell(wb, this.csw, step.getRequired());
            for (int i = 0; i < resultOK; ++i) {
                if (step.getResultOK(i) == TaxStatementReportResult.ERROR || step.getResultOK(i) == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || step.getResultOK(i) == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
                    cx = this.csw;
                } else if (step.getResultOK(i) == TaxStatementReportResult.FATAL) {
                    cx = this.csw;
                } else if (step.getResultOK(i) == TaxStatementReportResult.OK) {
                    cx = this.cswg;
                } else if (step.getResultOK(i) == TaxStatementReportResult.SELECT) {
                    cx = this.cswb;
                } else if (step.getResultOK(i) == TaxStatementReportResult.WARNING) {
                    cx = this.cswg;
                }
                TaxStatementReportUtil.addCell(wb, cx, step.getResultOK(i));
            }
            TaxStatementReportUtil.addCell(wb, this.css, step.getReasonRemark(cs));
            if (step.getResult() == TaxStatementReportResult.ERROR || step.getResult() == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || step.getResult() == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
                cx = this.cswr;
            } else if (step.getResult() == TaxStatementReportResult.FATAL) {
                cx = this.cswv;
            } else if (step.getResult() == TaxStatementReportResult.IGNORE) {
                cx = this.csw;
            } else if (step.getResult() == TaxStatementReportResult.OK) {
                cx = this.cswg;
            } else if (step.getResult() == TaxStatementReportResult.SELECT) {
                cx = this.cswb;
            } else if (step.getResult() == TaxStatementReportResult.WARNING) {
                cx = this.cswy;
            }
            TaxStatementReportUtil.addCell(wb, cx, step.getResult());
            int col = 7 + resultOK;
            for (Integer index : indexesERROR) {
                String id;
                TaxStatementReportResultEntity entity = step.getEntity(index);
                if (entity == null || (id = entity.getId()) == null || id.length() <= 0) continue;
                if (entity.getResult() == TaxStatementReportResult.ERROR || entity.getResult() == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || entity.getResult() == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
                    cx = this.cswr;
                } else if (entity.getResult() == TaxStatementReportResult.FATAL) {
                    cx = this.cswv;
                } else if (entity.getResult() == TaxStatementReportResult.IGNORE) {
                    cx = this.csw;
                } else if (entity.getResult() == TaxStatementReportResult.OK) {
                    cx = this.cswg;
                } else if (entity.getResult() == TaxStatementReportResult.SELECT) {
                    cx = this.cswb;
                } else if (entity.getResult() == TaxStatementReportResult.WARNING) {
                    cx = this.cswy;
                }
                if (entity.getResult() == TaxStatementReportResult.ERROR || entity.getResult() == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || entity.getResult() == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
                    this.legendError = true;
                }
                if (entity.getResult() == TaxStatementReportResult.FATAL) {
                    this.legendFatal = true;
                }
                if (entity.getResult() == TaxStatementReportResult.IGNORE) {
                    this.legendIgnore = true;
                }
                if (entity.getResult() == TaxStatementReportResult.OK) {
                    this.legendOK = true;
                }
                if (entity.getResult() == TaxStatementReportResult.SELECT) {
                    this.legendSelect = true;
                }
                if (entity.getResult() == TaxStatementReportResult.WARNING) {
                    this.legendWarning = true;
                }
                if (indexesERROR.indexOf(index) == 0) {
                    TaxStatementReportUtil.addCell(wb, this.css);
                }
                TaxStatementReportUtil.addCell(wb, cx, entity.getResult());
                int offset = index.toString().length() + 2;
                if (id.length() + offset >= 12) {
                    int length = 12;
                    if (id.indexOf("\r\n") > 0) {
                        if (id.indexOf("\r\n") + offset + 1 > length) {
                            length = id.indexOf("\r\n") + offset + 1;
                        } else {
                            String part = id.substring(id.indexOf("\r\n") + 2);
                            if (part != null && part.length() + 1 > length) {
                                length = part.length() + offset + 1;
                            }
                        }
                    } else if (id.charAt(0) >= 'A' && id.charAt(0) <= 'Z' && id.charAt(1) >= 'A' && id.charAt(1) <= 'Z' && id.charAt(2) >= 'A' && id.charAt(2) <= 'Z' || id.charAt(2) >= '0' && id.charAt(2) <= '9') {
                        length = id.length() + offset + 1;
                    } else if (id.charAt(0) >= '0' && id.charAt(0) <= '9' && id.charAt(1) >= '0' && id.charAt(1) <= '9' && id.charAt(2) >= '0' && id.charAt(2) <= '9') {
                        length = id.length() + offset + 1;
                    }
                    int width = TaxStatementReportUtil.getSheet(wb).getColumnWidth(col) / 256;
                    if (length > width) {
                        TaxStatementReportUtil.getSheet(wb).setColumnWidth(col, length * 256);
                    }
                } else {
                    TaxStatementReportUtil.getSheet(wb).setColumnWidth(col, 3072);
                }
                TaxStatementReportUtil.getSheet(wb).getPrintSetup().setLandscape(true);
                TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFitWidth((short)(1 + (step.getEntities().size() + 8) / 16));
                ++col;
            }
            if (step.getResultOK().contains((Object)TaxStatementReportResult.IGNORE)) {
                this.legendIgnore = true;
            }
            if (step.getRequired() == TaxStatementReportResult.ERROR || step.getRequired() == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || step.getRequired() == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
                this.legendError = true;
            } else if (step.getRequired() == TaxStatementReportResult.FATAL) {
                this.legendFatal = true;
            } else if (step.getRequired() == TaxStatementReportResult.OK) {
                this.legendMandatory = true;
            } else if (step.getRequired() == TaxStatementReportResult.SELECT) {
                this.legendIgnore = true;
            } else if (step.getRequired() == TaxStatementReportResult.WARNING) {
                this.legendWarning = true;
            }
            String reason = step.getReason();
            if (reason != null && reason.indexOf(TaxStatementReportOperator.APPROXIMATELY.toString()) >= 0) {
                this.legendApproximately = true;
            }
            if (reason != null && reason.indexOf(TaxStatementReportOperator.GREATER.toString()) >= 0) {
                this.legendGreater = true;
            }
            if (reason != null && reason.indexOf(TaxStatementReportOperator.SMALLER.toString()) >= 0) {
                this.legendSmaller = true;
            }
            if (reason != null && reason.indexOf(TaxStatementReportOperator.NOTEQUAL.toString()) >= 0) {
                this.legendNotEqual = true;
            }
            if (reason != null && reason.indexOf(TaxStatementReportOperator.NOTGREATER.toString()) >= 0) {
                this.legendNotGreater = true;
            }
            if (reason != null && reason.indexOf(TaxStatementReportOperator.NOTGREATEREQUAL.toString()) >= 0) {
                this.legendNotGreaterEqual = true;
            }
            if (reason != null && reason.indexOf(TaxStatementReportOperator.NOTSMALLER.toString()) >= 0) {
                this.legendNotSmaller = true;
            }
            if (reason == null || reason.indexOf(TaxStatementReportOperator.NOTSMALLEREQUAL.toString()) < 0) continue;
            this.legendNotSmallerEqual = true;
        }
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addCell(wb, this.csw);
        boolean bl = false;
        while (var9_13 < resultOK) {
            TaxStatementReportUtil.addCell(wb, this.csw);
            ++var9_13;
        }
        TaxStatementReportUtil.addCell(wb, this.css);
        CellStyle cellStyle = this.css;
        if (cs.getResult() == TaxStatementReportResult.ERROR || cs.getResult() == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || cs.getResult() == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
            CellStyle cellStyle2 = this.cswbr;
        } else if (cs.getResult() == TaxStatementReportResult.FATAL) {
            CellStyle cellStyle3 = this.cswbv;
        } else if (cs.getResult() == TaxStatementReportResult.IGNORE) {
            CellStyle cellStyle4 = this.cswbx;
        } else if (cs.getResult() == TaxStatementReportResult.OK) {
            CellStyle cellStyle5 = this.cswbg;
        } else if (cs.getResult() == TaxStatementReportResult.SELECT) {
            CellStyle cellStyle6 = this.cswbb;
        } else if (cs.getResult() == TaxStatementReportResult.WARNING) {
            CellStyle cellStyle7 = this.cswby;
        }
        TaxStatementReportUtil.addCell(wb, (CellStyle)var9_21, cs.getResult());
        TaxStatementReportUtil.getSheet(wb).groupRow(firstRow + 1, TaxStatementReportUtil.getNumberOfRows(wb) - 2);
        TaxStatementReportUtil.getSheet(wb).setRowSumsBelow(false);
        if (cs.getResult() == TaxStatementReportResult.OK || cs.getResult() != TaxStatementReportResult.IGNORE) {
            // empty if block
        }
        TaxStatementReportUtil.getSheet(wb).setRowGroupCollapsed(firstRow + 1, true);
        if (cs.getResult() == TaxStatementReportResult.ERROR || cs.getResult() == TaxStatementReportResult.FATAL || cs.getResult() == TaxStatementReportResult.WARNING) {
            System.setProperty("EXIT", "1");
        }
        if (cs.getResult() == TaxStatementReportResult.ERROR || cs.getResult() == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || cs.getResult() == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
            this.legendError = true;
        } else if (cs.getResult() == TaxStatementReportResult.FATAL) {
            this.legendFatal = true;
        } else if (cs.getResult() == TaxStatementReportResult.IGNORE) {
            this.legendIgnore = true;
        } else if (cs.getResult() == TaxStatementReportResult.OK) {
            this.legendOK = true;
        } else if (cs.getResult() == TaxStatementReportResult.SELECT) {
            this.legendSelect = true;
        } else if (cs.getResult() == TaxStatementReportResult.WARNING) {
            this.legendWarning = true;
        }
    }

    protected void addLegend(Workbook wb, Properties lang) {
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.cssc);
        TaxStatementReportUtil.addCell(wb, this.css);
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, LEGEND_NAME));
        TaxStatementReportUtil.addCell(wb, this.css);
        if (this.legendMandatory) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.csw, TaxStatementReportResult.OK);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_MANDATORY));
        }
        if (this.legendIgnore) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.csw, TaxStatementReportResult.IGNORE);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_IGNORE));
        }
        if (this.legendOK) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cswg, TaxStatementReportResult.OK);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_OK));
        }
        if (this.legendError) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cswr, TaxStatementReportResult.ERROR);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_ERROR));
        }
        if (this.legendFatal) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cswv, TaxStatementReportResult.FATAL);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_FATAL));
        }
        if (this.legendWarning) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cswy, TaxStatementReportResult.WARNING);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_WARNING));
        }
        if (this.legendSelect) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cswb, TaxStatementReportResult.SELECT);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_SELECT));
        }
        if (this.legendApproximately) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.APPROXIMATELY);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_APPROXIMATELY));
        }
        if (this.legendGreater) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.GREATER);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_GREATER));
        }
        if (this.legendSmaller) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.SMALLER);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_SMALLER));
        }
        if (this.legendNotEqual) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.NOTEQUAL);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_NOTEQUAL));
        }
        if (this.legendNotGreater) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.NOTGREATER);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_NOTGREATER));
        }
        if (this.legendNotGreaterEqual) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.NOTGREATEREQUAL);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_NOTGREATEREQUAL));
        }
        if (this.legendNotSmaller) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.NOTSMALLER);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_NOTSMALLER));
        }
        if (this.legendNotSmallerEqual) {
            TaxStatementReportUtil.addRow(wb);
            TaxStatementReportUtil.addCell(wb, this.cssc, TaxStatementReportOperator.NOTSMALLEREQUAL);
            TaxStatementReportUtil.addCell(wb, this.css, TaxStatementReportUtil.getText(lang, LEGEND_NOTSMALLEREQUAL));
        }
    }

    public void translate(Workbook wb, String name, Properties lang, List<TaxStatementReportResultCase> cases) {
        this.initFont(wb);
        this.initStyle(wb);
        this.initSheet(wb, lang, name);
        if (cases != null) {
            for (TaxStatementReportResultCase cs : cases) {
                this.addCase(cs, wb, lang);
            }
        }
        this.addLegend(wb, lang);
    }

    public TaxStatementReportSSKEntity(int resultOK) {
        this.resultOK = resultOK;
        this.cases = new ArrayList<TaxStatementReportResultCase>();
    }
}

