/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report.ssk;

import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.xml.sax.SAXException;

public class TaxStatementReportSSKSummaryDetail {
    public static final String CATEGORY_CHANGE = "CATEGORY_CHANGE";
    public static final String CATEGORY_CRITICAL = "CATEGORY_CRITICAL";
    public static final String CATEGORY_MAIN = "CATEGORY_MAIN";
    public static final String CATEGORY_MINOR = "CATEGORY_MINOR";
    public static final String CATEGORY_NONE = "CATEGORY_NONE";
    public static final String CATEGORY_UNCRITICAL = "CATEGORY_UNCRITICAL";
    public static final String RESULT_DETAIL_CATEGORY = "RESULT_DETAIL_CATEGORY";
    public static final String RESULT_DETAIL_DEFECT_NUMBER = "RESULT_DETAIL_DEFECT_NUMBER";
    public static final String RESULT_DETAIL_DESCRIPTION = "RESULT_DETAIL_DESCRIPTION";
    public static final String RESULT_DETAIL_OVERVIEW = "RESULT_DETAIL_OVERVIEW";
    public static final String RESULT_DETAIL_RESPONSIBLE = "RESULT_DETAIL_RESPONSIBLE";
    public static final String RESULT_DETAIL_SHEET = "RESULT_DETAIL_SHEET";
    public static final String RESULT_DETAIL_TESTCASE = "RESULT_DETAIL_TESTCASE";
    public static final String SHEET = "SHEET_DETAIL";
    public static final String SHEET_OVERVIEW = "SHEET_OVERVIEW";
    public static final String SHEET_SCHEMA = "SHEET_SCHEMA";
    public static final String SHEET_TAX_STATEMENT = "SHEET_TAX_STATEMENT";
    public static final String SHEET_INSTITUTION = "SHEET_INSTITUTION";
    public static final String SHEET_CLIENT = "SHEET_CLIENT";
    public static final String SHEET_BANK_ACCOUNT = "SHEET_BANK_ACCOUNT";
    public static final String SHEET_LIABILITY_ACCOUNT = "SHEET_LIABILITY_ACCOUNT";
    public static final String SHEET_EXPENSE = "SHEET_EXPENSE";
    public static final String SHEET_SECURITY = "SHEET_SECURITY";
    private Font fth;
    private Font fts;
    private CellStyle csh;
    private CellStyle css;
    private CellStyle csw;

    protected void addConstraint(Sheet sheet, int column, String[] names) {
        List<String> list = Arrays.asList(names);
        Collections.sort(list);
        XSSFDataValidationHelper helper = new XSSFDataValidationHelper((XSSFSheet)sheet);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(list.toArray(new String[0]));
        DataValidation validation = helper.createValidation(constraint, new CellRangeAddressList(1, TaxStatementReportUtil.getNumberOfRows(sheet) - 1, column, column));
        validation.setSuppressDropDownArrow(true);
        sheet.addValidationData(validation);
    }

    protected void initFont(Workbook wb) {
        this.fth = wb.createFont();
        this.fts = wb.createFont();
        this.fth.setFontName("Calibri");
        this.fth.setFontHeightInPoints((short)11);
        this.fth.setBold(true);
        this.fts.setFontName("Calibri");
        this.fts.setFontHeightInPoints((short)11);
    }

    protected void initStyle(Workbook wb) {
        this.csh = wb.createCellStyle();
        this.css = wb.createCellStyle();
        this.csw = wb.createCellStyle();
        this.csh.setFont(this.fth);
        this.csh.setAlignment(HorizontalAlignment.LEFT);
        this.csh.setVerticalAlignment(VerticalAlignment.TOP);
        this.css.setFont(this.fts);
        this.css.setAlignment(HorizontalAlignment.LEFT);
        this.css.setVerticalAlignment(VerticalAlignment.TOP);
        this.csw.setFont(this.fts);
        this.csw.setAlignment(HorizontalAlignment.LEFT);
        this.csw.setVerticalAlignment(VerticalAlignment.TOP);
        this.csw.setWrapText(true);
    }

    protected void initSheet(Workbook wb, Properties lang, String sheet) throws IOException {
        TaxStatementReportUtil.addSheet(wb, TaxStatementReportUtil.getText(lang, sheet));
        TaxStatementReportUtil.addRow(wb);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, RESULT_DETAIL_TESTCASE));
        TaxStatementReportUtil.setWidth(wb, 11);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, RESULT_DETAIL_SHEET));
        TaxStatementReportUtil.setWidth(wb, 16);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, RESULT_DETAIL_OVERVIEW));
        TaxStatementReportUtil.setWidth(wb, 30);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, RESULT_DETAIL_DESCRIPTION));
        TaxStatementReportUtil.setWidth(wb, 45);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, RESULT_DETAIL_CATEGORY));
        TaxStatementReportUtil.setWidth(wb, 20);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, RESULT_DETAIL_RESPONSIBLE));
        TaxStatementReportUtil.setWidth(wb, 12);
        TaxStatementReportUtil.addCell(wb, this.csh, TaxStatementReportUtil.getText(lang, RESULT_DETAIL_DEFECT_NUMBER));
        TaxStatementReportUtil.setWidth(wb, 12);
        TaxStatementReportUtil.addCell(wb, this.csh);
        TaxStatementReportUtil.setWidth(wb, 100);
        TaxStatementReportUtil.setHidden(wb, true);
        TaxStatementReportUtil.getSheet(wb).setFitToPage(true);
        TaxStatementReportUtil.getSheet(wb).setDisplayGridlines(true);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.TOP, 0.5);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.BOTTOM, 0.5);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.LEFT, 0.3);
        TaxStatementReportUtil.getSheet(wb).setMargin(PageMargin.RIGHT, 0.3);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        TaxStatementReportUtil.getSheet(wb).getFooter().setLeft(sdf.format(new Date()));
        TaxStatementReportUtil.getSheet(wb).getFooter().setRight(TaxStatementReportUtil.getVersion());
        TaxStatementReportUtil.getSheet(wb).setDisplayGridlines(true);
        TaxStatementReportUtil.getSheet(wb).setPrintGridlines(true);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setPaperSize((short)9);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setLandscape(true);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFitWidth((short)1);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFitHeight((short)1);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setHeaderMargin(0.2);
        TaxStatementReportUtil.getSheet(wb).getPrintSetup().setFooterMargin(0.3);
    }

    public void translate(Workbook wb, Properties lang) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.initFont(wb);
        this.initStyle(wb);
        this.initSheet(wb, lang, SHEET);
    }

    public void translate(Workbook wb, Properties lang, List<TaxStatementReportResultCase> caseResults) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        int i;
        Sheet sheet = TaxStatementReportUtil.getSheet(wb, TaxStatementReportUtil.getText(lang, SHEET));
        String concat = new String("");
        for (TaxStatementReportResultCase caseResult : caseResults) {
            if (caseResult.getResult() != TaxStatementReportResult.ERROR && caseResult.getResult() != TaxStatementReportResult.FATAL && caseResult.getResult() != TaxStatementReportResult.IGNORE && caseResult.getResult() != TaxStatementReportResult.SELECT && caseResult.getResult() != TaxStatementReportResult.WARNING) continue;
            String category = null;
            if (caseResult.getResult() == TaxStatementReportResult.ERROR || caseResult.getResult() == TaxStatementReportResult.FATAL && TaxStatementReportProperty.SSK || caseResult.getResult() == TaxStatementReportResult.WARNING && TaxStatementReportProperty.SSK) {
                category = CATEGORY_MAIN;
            } else if (caseResult.getResult() == TaxStatementReportResult.FATAL) {
                category = CATEGORY_CRITICAL;
            } else if (caseResult.getResult() == TaxStatementReportResult.IGNORE) {
                category = CATEGORY_UNCRITICAL;
            } else if (caseResult.getResult() == TaxStatementReportResult.SELECT) {
                category = CATEGORY_NONE;
            } else if (caseResult.getResult() == TaxStatementReportResult.WARNING) {
                category = CATEGORY_MINOR;
            }
            TaxStatementReportUtil.addRow(sheet);
            TaxStatementReportUtil.addCell(sheet, this.css, caseResult.getName());
            TaxStatementReportUtil.addCell(sheet, this.css, caseResult.getGroup());
            TaxStatementReportUtil.addCell(sheet, this.csw, caseResult.getDescription());
            TaxStatementReportUtil.addCell(sheet, this.csw, caseResult.getResults());
            TaxStatementReportUtil.addCell(sheet, this.css, TaxStatementReportUtil.getText(lang, category));
            TaxStatementReportUtil.addCell(sheet, this.csw);
            TaxStatementReportUtil.addCell(sheet, this.css);
            TaxStatementReportUtil.addCell(sheet, this.csw);
            TaxStatementReportUtil.getCell(sheet).setCellFormula("IF(G" + TaxStatementReportUtil.getNumberOfRows(sheet) + "=\"\",\"\",CHAR(149)&\" \"&B" + TaxStatementReportUtil.getNumberOfRows(sheet) + "&\": \"&C" + TaxStatementReportUtil.getNumberOfRows(sheet) + "&\" [\"&G" + TaxStatementReportUtil.getNumberOfRows(sheet) + "&\"]\"&CHAR(10))");
        }
        for (i = 0; i < 5; ++i) {
            TaxStatementReportUtil.addRow(sheet);
            TaxStatementReportUtil.addCell(sheet, this.css);
            TaxStatementReportUtil.addCell(sheet, this.css);
            TaxStatementReportUtil.addCell(sheet, this.csw);
            TaxStatementReportUtil.addCell(sheet, this.csw);
            TaxStatementReportUtil.addCell(sheet, this.css);
            TaxStatementReportUtil.addCell(sheet, this.csw);
            TaxStatementReportUtil.addCell(sheet, this.css);
            TaxStatementReportUtil.addCell(sheet, this.csw);
            TaxStatementReportUtil.getCell(sheet).setCellFormula("IF(G" + TaxStatementReportUtil.getNumberOfRows(sheet) + "=\"\",\"\",CHAR(149)&\" \"&B" + TaxStatementReportUtil.getNumberOfRows(sheet) + "&\": \"&C" + TaxStatementReportUtil.getNumberOfRows(sheet) + "&\" [\"&G" + TaxStatementReportUtil.getNumberOfRows(sheet) + "&\"]\"&CHAR(10))");
        }
        this.addConstraint(sheet, 1, new String[]{TaxStatementReportUtil.getText(lang, SHEET_BANK_ACCOUNT), TaxStatementReportUtil.getText(lang, SHEET_CLIENT), TaxStatementReportUtil.getText(lang, SHEET_EXPENSE), TaxStatementReportUtil.getText(lang, SHEET_INSTITUTION), TaxStatementReportUtil.getText(lang, SHEET_LIABILITY_ACCOUNT), TaxStatementReportUtil.getText(lang, SHEET_SCHEMA), TaxStatementReportUtil.getText(lang, SHEET_SECURITY), TaxStatementReportUtil.getText(lang, SHEET_TAX_STATEMENT)});
        this.addConstraint(sheet, 4, new String[]{TaxStatementReportUtil.getText(lang, CATEGORY_CHANGE), TaxStatementReportUtil.getText(lang, CATEGORY_CRITICAL), TaxStatementReportUtil.getText(lang, CATEGORY_MAIN), TaxStatementReportUtil.getText(lang, CATEGORY_MINOR), TaxStatementReportUtil.getText(lang, CATEGORY_NONE), TaxStatementReportUtil.getText(lang, CATEGORY_UNCRITICAL)});
        for (i = 1; i <= TaxStatementReportUtil.getNumberOfRows(sheet) && i <= 50; ++i) {
            if (concat.length() > 0) {
                concat = concat + ",";
            }
            concat = concat + "'" + TaxStatementReportUtil.getText(lang, SHEET) + "'!H" + i;
        }
        TaxStatementReportUtil.getSheet(wb, TaxStatementReportUtil.getText(lang, SHEET_OVERVIEW)).getRow(61).getCell(2).setCellFormula("CONCATENATE(" + concat + ")");
    }
}

