/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report.txt;

import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.ssk.TaxStatementReportSSK;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.xml.sax.SAXException;

public class TaxStatementReportTXT
extends TaxStatementReportSSK {
    public List<String> result() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.getWorkbook() != null) {
            Row row;
            Sheet sh;
            if (this.getWorkbook().getNumberOfSheets() > 2 && (sh = this.getWorkbook().getSheetAt(2)) != null && sh.getLastRowNum() > 1 && (row = sh.getRow(0)) != null && row.getLastCellNum() > 6) {
                Cell a = row.getCell(0);
                Cell b = row.getCell(1);
                Cell f = row.getCell(5);
                Cell g = row.getCell(6);
                if (a != null && a.getStringCellValue() != null && a.getStringCellValue().length() > 0 && b != null && b.getStringCellValue() != null && b.getStringCellValue().length() > 0 && f != null && f.getStringCellValue() != null && f.getStringCellValue().length() > 0 && g != null && g.getStringCellValue() != null && g.getStringCellValue().length() > 0) {
                    String line = a.getStringCellValue().replace(";", "").replace("\r\n", " ").replace("\r", " ").replace("\n", " ") + ";" + b.getStringCellValue().replace(";", "").replace("\r\n", " ").replace("\r", " ").replace("\n", " ") + ";" + g.getStringCellValue().replace(";", "").replace("\r\n", " ").replace("\r", " ").replace("\n", " ") + ";" + f.getStringCellValue().replace(";", "").replace("\r\n", " ").replace("\r", " ").replace("\n", " ");
                    list.add(line);
                }
            }
            for (int s = 2; s < this.getWorkbook().getNumberOfSheets(); ++s) {
                Sheet sh2 = this.getWorkbook().getSheetAt(s);
                if (sh2 == null || sh2.getLastRowNum() <= 1) continue;
                for (int r = 1; r < sh2.getLastRowNum(); ++r) {
                    String result;
                    int i;
                    Row row2 = sh2.getRow(r);
                    if (row2 == null || row2.getLastCellNum() <= 2) continue;
                    Cell a = row2.getCell(0);
                    Cell b = row2.getCell(1);
                    Cell f = null;
                    Cell g = null;
                    if (a == null || a.getStringCellValue() == null || a.getStringCellValue().length() <= 0 || b == null || b.getStringCellValue() == null || b.getStringCellValue().length() <= 0) continue;
                    String line = a.getStringCellValue().replace(";", "").replace("\r\n", " ") + ";" + b.getStringCellValue().replace(";", "").replace("\r\n", " ") + ";";
                    if ((a.getStringCellValue().startsWith("SCHEMA-") || a.getStringCellValue().startsWith("INSTITUT-") || a.getStringCellValue().startsWith("CLIENT-")) && row2.getLastCellNum() > 5) {
                        f = row2.getCell(5);
                        g = row2.getCell(6);
                    } else if (a.getStringCellValue().startsWith("TAXSTA-") && row2.getLastCellNum() > 8) {
                        f = row2.getCell(7);
                        g = row2.getCell(8);
                    } else if ((a.getStringCellValue().startsWith("BANKAC-") || a.getStringCellValue().startsWith("LIABILITY-") || a.getStringCellValue().startsWith("EXPENSE-")) && row2.getLastCellNum() > 9) {
                        f = row2.getCell(8);
                        g = row2.getCell(9);
                    } else if (a.getStringCellValue().startsWith("SECURITY-") && row2.getLastCellNum() > 10) {
                        f = row2.getCell(9);
                        g = row2.getCell(10);
                    }
                    if (g != null && (g.getStringCellValue() == null || g.getStringCellValue().length() == 0)) {
                        Cell gg = null;
                        i = 1;
                        while (r + i < sh2.getLastRowNum() && gg == null) {
                            if (sh2.getRow(r + i) != null && (sh2.getRow(r + i).getCell(0) == null || sh2.getRow(r + i).getCell(0) != null && (sh2.getRow(r + i).getCell(0).getStringCellValue() == null || sh2.getRow(r + i).getCell(0).getStringCellValue().length() == 0))) {
                                gg = sh2.getRow(r + i).getCell(g.getColumnIndex());
                            }
                            ++i;
                        }
                        g = gg;
                    }
                    if (g != null && g.getStringCellValue() != null && g.getStringCellValue().length() > 0) {
                        Font font;
                        CellStyle cs;
                        if (g.getStringCellValue().equals(TaxStatementReportResult.OK.toString())) {
                            line = line + "1";
                        } else if ((g.getStringCellValue().equals(TaxStatementReportResult.FATAL.toString()) || g.getStringCellValue().equals(TaxStatementReportResult.ERROR.toString()) || g.getStringCellValue().equals(TaxStatementReportResult.WARNING.toString())) && (cs = g.getCellStyle()) != null && cs.getFontIndex() > 0 && (font = this.getWorkbook().getFontAt(cs.getFontIndex())) != null) {
                            line = font.getColor() == IndexedColors.VIOLET.index || font.getColor() == IndexedColors.RED.index || font.getColor() == IndexedColors.YELLOW.index ? line + "0" : line + "-";
                        }
                    }
                    ArrayList<String> data = null;
                    if (g != null && g.getRowIndex() != r) {
                        data = new ArrayList<String>();
                        i = 2;
                        while (g.getColumnIndex() + i < row2.getLastCellNum()) {
                            String l;
                            Cell h = row2.getCell(g.getColumnIndex() + i);
                            if (h != null && (l = h.getStringCellValue()) != null && l.length() > 0 && l.indexOf(")") > 0 && l.startsWith("(")) {
                                data.add(l.substring(0, l.indexOf(")") + 1));
                                line = line + ";";
                                line = line + l.replace(";", "").replace(")", ") ").replace("\r\n", ", ");
                            }
                            ++i;
                        }
                        if (data.size() == 0) {
                            data = null;
                        }
                    }
                    if (f != null && f.getStringCellValue() != null && (result = f.getStringCellValue().replace(";", "").replace(TaxStatementReportOperator.APPROXIMATELY.toString(), "~").replace(TaxStatementReportOperator.NOTEQUAL.toString(), "!=").replace(TaxStatementReportOperator.NOTGREATER.toString(), "!>").replace(TaxStatementReportOperator.NOTGREATEREQUAL.toString(), "!>=").replace(TaxStatementReportOperator.NOTSMALLER.toString(), "!<").replace(TaxStatementReportOperator.NOTSMALLEREQUAL.toString(), "!<=")) != null && result.length() > 0) {
                        if (!result.startsWith("(") || data == null) {
                            line = line + ";";
                            line = line + result.replace("\r\n", ";");
                        } else {
                            for (String split : result.split("\r\n")) {
                                for (String l : data) {
                                    if (split == null || l == null || !split.startsWith(l)) continue;
                                    line = line + ";";
                                    line = line + split;
                                }
                            }
                        }
                    }
                    list.add(line);
                }
            }
        }
        return list;
    }

    @Override
    protected void save(String name) throws IOException {
        if (name != null && (name.endsWith(".csv") || name.endsWith(".pdf") || name.endsWith(".xlsx") || name.endsWith(".xml"))) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(name.replace(".pdf", ".csv").replace(".xlsx", ".csv").replace(".xml", ".csv")));
            for (String line : this.result()) {
                if (line == null) continue;
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
    }

    public TaxStatementReportTXT() {
    }

    public TaxStatementReportTXT(String[] args) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        super.translate(args);
    }
}

