/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassFactory;
import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import java.lang.reflect.Array;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ArrayParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!elementName.equals("array")) {
            throw new ElementParserException("array-parser can not handle elements with the name=" + elementName);
        }
        String type = element.getAttribute("elementtype");
        if (type == null || type.isEmpty()) {
            throw new ElementParserException("Attribute 'elementtype' may not be null/empty on element " + element.getNodeName());
        }
        Class<?> arrayClass = null;
        try {
            arrayClass = ClassFactory.getKlass(type);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("ArrayParser: ClassFactory could NOT create array-class for type=" + type, ex);
        }
        List<Element> arrayChildren = element.getChildElements();
        Object array = Array.newInstance(arrayClass, arrayChildren.size());
        for (int i = 0; i < arrayChildren.size(); ++i) {
            Element el = arrayChildren.get(i);
            try {
                ClassObjectPair cop = factory.getParser(el.getNodeName()).parse(el, factory);
                Array.set(array, i, cop.getObject());
                continue;
            }
            catch (ParserNotRegisteredException ex) {
                throw new ElementParserException("ArrayParser: could NOT find parser for name=" + el.getNodeName(), ex);
            }
            catch (Exception ex) {
                throw new ElementParserException("ArrayParser: Could NOT set value into array", ex);
            }
        }
        Class<?> klass = array.getClass();
        return new ClassObjectPair(klass, array);
    }
}

