/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassFactory;
import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CastParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        ClassObjectPair retVal;
        String elementName = element.getNodeName();
        if (!elementName.equals("cast")) {
            throw new ElementParserException("cast-parser can not handle elements with the name=" + elementName);
        }
        String className = element.getAttribute("class");
        if (className == null || className.isEmpty()) {
            throw new ElementParserException("attribute 'class' may not be null or empty on element " + element.getNodeName());
        }
        List<Element> children = element.getChildElements();
        if (children.size() != 1) {
            throw new ElementParserException("a cast-tag must have exactly ONE child");
        }
        Element child = children.get(0);
        try {
            ClassObjectPair cop = factory.getParser(child.getNodeName()).parse(child, factory);
            Class<?> klass = ClassFactory.getKlass(className);
            retVal = new ClassObjectPair(klass, cop.getObject());
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("could not find class for name=" + className, ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException("could not find a parser for cast-child", ex);
        }
        return retVal;
    }
}

