/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import java.lang.reflect.Array;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ClassFactory {
    private ClassFactory() {
    }

    public static @NonNull Class<?> getKlass(@NonNull String type) throws ClassNotFoundException {
        Class retVal = null;
        if (type.equalsIgnoreCase("string")) {
            retVal = String.class;
        } else if (type.equalsIgnoreCase("int")) {
            retVal = Integer.TYPE;
        } else if (type.equalsIgnoreCase("long")) {
            retVal = Long.TYPE;
        } else if (type.equalsIgnoreCase("short")) {
            retVal = Short.TYPE;
        } else if (type.equalsIgnoreCase("float")) {
            retVal = Float.TYPE;
        } else if (type.equalsIgnoreCase("double")) {
            retVal = Double.TYPE;
        } else if (type.equalsIgnoreCase("boolean")) {
            retVal = Boolean.TYPE;
        } else if (type.equalsIgnoreCase("char")) {
            retVal = Character.TYPE;
        } else if (type.endsWith("[]")) {
            String baseType = type.substring(0, type.length() - 2);
            Class<?> baseClass = ClassFactory.getKlass(baseType);
            retVal = Array.newInstance(baseClass, 0).getClass();
        } else {
            retVal = Class.forName(type);
        }
        return retVal;
    }
}

