/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.ConstructionException;
import java.lang.reflect.Constructor;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Construct {
    private final @NonNull Class<?> klass;
    private final @NonNull Class<?>[] argClasses;
    private final @NonNull Object[] initArgs;

    public Construct(@NonNull Class<?> klass, @NonNull Class<?>[] argClasses, @NonNull Object[] argValues) {
        this.klass = klass;
        this.argClasses = (Class[])argClasses.clone();
        this.initArgs = (Object[])argValues.clone();
    }

    public Object getObject() throws ConstructionException {
        try {
            Constructor<?> constructor = this.getKlass().getConstructor(this.getArgClasses());
            return constructor.newInstance(this.getInitArgs());
        }
        catch (Exception ex) {
            throw new ConstructionException(ex);
        }
    }

    public @NonNull Class<?> getKlass() {
        return this.klass;
    }

    public @NonNull Class<?>[] getArgClasses() {
        return this.argClasses;
    }

    public @NonNull Object[] getInitArgs() {
        return this.initArgs;
    }
}

