/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.ConstructionException;
import ch.dvbern.oss.construct.xml.ClassFactory;
import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Construct;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConstructParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        ClassObjectPair retVal;
        String className = element.getAttribute("class");
        if (className == null || className.isEmpty()) {
            throw new ElementParserException("attribute 'class' may not be null on " + element.getNodeName());
        }
        Class<?> klass = null;
        try {
            klass = ClassFactory.getKlass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("classLoader could NOT load class for name=" + className, ex);
        }
        List<Element> argChildren = element.getChildElements();
        ArrayList argClasses = new ArrayList(argChildren.size());
        ArrayList<Object> initArgs = new ArrayList<Object>(argChildren.size());
        for (Element el : argChildren) {
            try {
                ClassObjectPair cop = factory.getParser(el.getNodeName()).parse(el, factory);
                argClasses.add(cop.getKlass());
                initArgs.add(cop.getObject());
            }
            catch (ParserNotRegisteredException ex) {
                throw new ElementParserException("no parser found for element name=" + el.getNodeName(), ex);
            }
        }
        Construct construct = new Construct(klass, argClasses.toArray(new Class[argClasses.size()]), initArgs.toArray(new Object[initArgs.size()]));
        try {
            retVal = new ClassObjectPair(construct.getKlass(), construct.getObject());
        }
        catch (ConstructionException ex) {
            throw new ElementParserException(ex);
        }
        return retVal;
    }
}

