/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Element {
    private final @NonNull org.w3c.dom.Element nestedElement;

    public Element(@NonNull org.w3c.dom.Element nestedElement) {
        this.nestedElement = nestedElement;
    }

    public @NonNull Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        NamedNodeMap nnm = this.nestedElement.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node node = nnm.item(i);
            result.put(node.getNodeName(), node.getNodeValue());
        }
        return result;
    }

    public @Nullable String getAttribute(@NonNull String name) {
        return this.getAttributeValue(name);
    }

    public @Nullable String getAttributeValue(@NonNull String name) {
        if (!this.nestedElement.hasAttribute(name)) {
            return null;
        }
        return this.nestedElement.getAttribute(name);
    }

    public @NonNull List<Element> getElementsByTagName(@NonNull String name) {
        NodeList nodeList = this.nestedElement.getElementsByTagName(name).item(0).getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add(new Element((org.w3c.dom.Element)nodeList.item(i)));
        }
        return result;
    }

    public @NonNull String getNodeName() {
        return this.nestedElement.getNodeName();
    }

    public @NonNull String getName() {
        return this.nestedElement.getNodeName();
    }

    public @NonNull List<Element> getChildElements() {
        NodeList nodeList = this.nestedElement.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof org.w3c.dom.Element)) continue;
            org.w3c.dom.Element elementItem = (org.w3c.dom.Element)node;
            result.add(new Element(elementItem));
        }
        return result;
    }

    public @NonNull List<Element> getChildren() {
        return this.getChildElements();
    }

    public @Nullable Element getParent() {
        return new Element((org.w3c.dom.Element)this.nestedElement.getParentNode());
    }
}

