/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ResourceChangeListener;
import ch.dvbern.oss.construct.xml.ResourceChangedEvent;
import ch.dvbern.oss.construct.xml.ResourceLocator;
import ch.dvbern.oss.construct.xml.ResourceNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathResourceLocator
implements ResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(FilePathResourceLocator.class);
    private final @NonNull String path;
    private final @NonNull HashSet<ResourceChangeListener> listeners;
    private final @NonNull HashSet<File> files;
    private final @NonNull ResourceChecker resourceChecker;

    public FilePathResourceLocator(@NonNull String path) {
        this(path, 10000L);
    }

    public FilePathResourceLocator(@NonNull String path, long resChangeCheckPeriod) {
        this.path = path;
        this.listeners = new HashSet();
        this.files = new HashSet();
        this.resourceChecker = new ResourceChecker(resChangeCheckPeriod);
        Thread thread = new Thread(this.resourceChecker);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull InputStream getResourceAsStream(@NonNull String resourceName) throws ResourceNotFoundException {
        try {
            File file = new File(this.path, resourceName);
            HashSet<File> hashSet = this.files;
            synchronized (hashSet) {
                this.files.add(file);
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new ResourceNotFoundException("resource=" + resourceName + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceChangeListener(@NonNull ResourceChangeListener listener) {
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceChangeListener(@NonNull ResourceChangeListener listener) {
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResourceChange(@NonNull String resource) {
        Set clone;
        ResourceChangedEvent event = new ResourceChangedEvent(this, resource);
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            Set tmp;
            clone = tmp = (Set)this.listeners.clone();
        }
        for (ResourceChangeListener listener : clone) {
            try {
                listener.resourceChanged(event);
            }
            catch (RuntimeException ex) {
                LOG.error("Error while notifying listener: {}", (Object)listener, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResourceRemoved(@NonNull String resource) {
        Set clone;
        ResourceChangedEvent event = new ResourceChangedEvent(this, resource);
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            Set tmp;
            clone = tmp = (Set)this.listeners.clone();
        }
        for (ResourceChangeListener listener : clone) {
            try {
                listener.resourceRemoved(event);
            }
            catch (RuntimeException ex) {
                LOG.error("Error while notifying listener: {}", (Object)listener, (Object)ex);
            }
        }
    }

    public void stopResourceChecker() {
        this.resourceChecker.stopChecker();
    }

    private class ResourceChecker
    implements Runnable {
        private long lastCheck = System.currentTimeMillis();
        private final long checkPeriod;
        private volatile boolean run;

        public ResourceChecker(long checkPeriod) {
            this.checkPeriod = checkPeriod;
            this.run = true;
        }

        public void stopChecker() {
            this.run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                Set clone;
                long tmpCheck = System.currentTimeMillis();
                HashSet<File> hashSet = FilePathResourceLocator.this.files;
                synchronized (hashSet) {
                    Set tmp;
                    clone = tmp = (Set)FilePathResourceLocator.this.files.clone();
                }
                for (File file : clone) {
                    if (!file.exists()) {
                        FilePathResourceLocator.this.notifyResourceRemoved(file.getName());
                        continue;
                    }
                    if (file.lastModified() < this.lastCheck) continue;
                    FilePathResourceLocator.this.notifyResourceChange(file.getName());
                }
                this.lastCheck = tmpCheck;
                try {
                    Thread.sleep(this.checkPeriod);
                }
                catch (InterruptedException ex) {
                    LOG.warn("Interrupted while waiting for checkPeriod of {}ms", (Object)this.checkPeriod, (Object)ex);
                }
            }
        }
    }
}

