/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GetFieldParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        Object myObject;
        String fieldName = Optional.ofNullable(element.getAttribute("name")).orElseThrow(() -> new ElementParserException("name attribute is missing"));
        List<Element> objectElChildren = element.getElementsByTagName("target");
        if (objectElChildren.size() != 1) {
            throw new ElementParserException("object must have exactly on child (construct or ref or cast...)");
        }
        Element objectElToParse = objectElChildren.get(0);
        Class<?> myClass = null;
        try {
            ClassObjectPair tmp = factory.getParser(objectElToParse.getNodeName()).parse(objectElToParse, factory);
            myObject = tmp.getObject();
            myClass = tmp.getKlass();
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException(ex);
        }
        ClassObjectPair cop = null;
        try {
            Field field = myClass.getField(fieldName);
            Object obj = field.get(myObject);
            cop = new ClassObjectPair(obj.getClass(), obj);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new ElementParserException(ex);
        }
        return cop;
    }
}

