/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class InvokeParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        Class<?> myClass;
        Object myObject;
        String methodName = Objects.requireNonNull(element.getAttribute("methodName"), "methodName is required");
        List<Element> objectElChildren = element.getElementsByTagName("target");
        if (objectElChildren.size() != 1) {
            throw new ElementParserException("object must have exactly on child (construct or ref or cast...)");
        }
        Element objectElToParse = objectElChildren.get(0);
        try {
            ClassObjectPair cop = factory.getParser(objectElToParse.getNodeName()).parse(objectElToParse, factory);
            myObject = cop.getObject();
            myClass = cop.getKlass();
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException(ex);
        }
        List<Element> parameterElList = element.getElementsByTagName("parameters");
        Class[] classArray = new Class[parameterElList.size()];
        Object[] objArray = new Object[parameterElList.size()];
        for (int i = 0; i < parameterElList.size(); ++i) {
            Element paramEl = parameterElList.get(i);
            try {
                ClassObjectPair cop = factory.getParser(paramEl.getNodeName()).parse(paramEl, factory);
                classArray[i] = cop.getKlass();
                objArray[i] = cop.getObject();
                continue;
            }
            catch (ParserNotRegisteredException ex) {
                throw new ElementParserException(ex);
            }
        }
        try {
            Method method = myClass.getMethod(methodName, classArray);
            Object obj = method.invoke(myObject, objArray);
            if (obj == null) {
                return new ClassObjectPair(Object.class, null);
            }
            return new ClassObjectPair(obj.getClass(), obj);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ElementParserException(ex);
        }
    }
}

