/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassFactory;
import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NullParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!elementName.equals("null")) {
            throw new ElementParserException("null-parser can not handle elements with the name=" + elementName);
        }
        String className = element.getAttribute("class");
        if (className == null) {
            throw new ElementParserException("could not find attribute with name class");
        }
        try {
            Class<?> clazz = ClassFactory.getKlass(className);
            return new ClassObjectPair(clazz, null);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("ArrayParser: ClassFactory could NOT create array-class for type=" + className, ex);
        }
    }
}

