/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ArrayParser;
import ch.dvbern.oss.construct.xml.CastParser;
import ch.dvbern.oss.construct.xml.ClassLoaderResourceLocator;
import ch.dvbern.oss.construct.xml.ClassParser;
import ch.dvbern.oss.construct.xml.ConstructParser;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.GetFieldParser;
import ch.dvbern.oss.construct.xml.InvokeParser;
import ch.dvbern.oss.construct.xml.NullParser;
import ch.dvbern.oss.construct.xml.ParserAlreadyRegisteredException;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.oss.construct.xml.PrimParser;
import ch.dvbern.oss.construct.xml.RefParser;
import ch.dvbern.oss.construct.xml.ResourceLocator;
import ch.dvbern.oss.construct.xml.ScriptParser;
import ch.dvbern.oss.construct.xml.SetFieldParser;
import ch.dvbern.oss.construct.xml.VarParser;
import ch.dvbern.oss.construct.xml.VardefParser;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ParserFactory {
    private final @NonNull Map<String, ElementParser> parsers = new HashMap<String, ElementParser>();
    private final @NonNull ResourceLocator locator;

    public ParserFactory() {
        this(new ClassLoaderResourceLocator());
    }

    public ParserFactory(@NonNull ResourceLocator locator) {
        this.locator = locator;
        this.init();
    }

    private void init() {
        this.parsers.put("ref", new RefParser());
        this.parsers.put("construct", new ConstructParser());
        this.parsers.put("array", new ArrayParser());
        this.parsers.put("short", new PrimParser());
        this.parsers.put("null", new NullParser());
        this.parsers.put("cast", new CastParser());
        this.parsers.put("class", new ClassParser());
        this.parsers.put("invoke", new InvokeParser());
        this.parsers.put("setfield", new SetFieldParser());
        this.parsers.put("getfield", new GetFieldParser());
        this.parsers.put("script", new ScriptParser());
        this.parsers.put("vardef", new VardefParser());
        this.parsers.put("var", new VarParser());
        PrimParser prim = new PrimParser();
        this.parsers.put("int", prim);
        this.parsers.put("short", prim);
        this.parsers.put("long", prim);
        this.parsers.put("float", prim);
        this.parsers.put("double", prim);
        this.parsers.put("char", prim);
        this.parsers.put("boolean", prim);
        this.parsers.put("string", prim);
    }

    public @NonNull ElementParser getParser(@NonNull String elementName) throws ParserNotRegisteredException {
        String lowerCaseName = elementName.toLowerCase();
        ElementParser parser = this.parsers.get(lowerCaseName);
        if (parser == null) {
            throw new ParserNotRegisteredException("there is no parser registered for elementName=" + lowerCaseName);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerParser(@NonNull String elementName, @NonNull ElementParser parser) throws ParserAlreadyRegisteredException {
        String lowerCaseName = elementName.toLowerCase();
        Map<String, ElementParser> map = this.parsers;
        synchronized (map) {
            if (this.parsers.containsKey(lowerCaseName)) {
                throw new ParserAlreadyRegisteredException("there is already a parser registered for elementName=" + lowerCaseName);
            }
            this.parsers.put(lowerCaseName, parser);
        }
    }

    public @NonNull ResourceLocator getResourceLocator() {
        return this.locator;
    }
}

