/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.ConstructionException;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PrimObjectFactory {
    private PrimObjectFactory() {
    }

    public static @NonNull Object getWrapper(@NonNull String type, @NonNull String strValue) throws ConstructionException {
        Object returnVal = null;
        try {
            if (type.equalsIgnoreCase("string")) {
                returnVal = strValue;
            } else if (type.equalsIgnoreCase("int")) {
                returnVal = Integer.valueOf(strValue);
            } else if (type.equalsIgnoreCase("long")) {
                returnVal = Long.valueOf(strValue);
            } else if (type.equalsIgnoreCase("short")) {
                returnVal = Short.valueOf(strValue);
            } else if (type.equalsIgnoreCase("float")) {
                returnVal = Float.valueOf(strValue);
            } else if (type.equalsIgnoreCase("double")) {
                returnVal = Double.valueOf(strValue);
            } else if (type.equalsIgnoreCase("boolean")) {
                returnVal = Boolean.valueOf(strValue);
            } else if (type.equalsIgnoreCase("char")) {
                if (strValue.length() != 1) {
                    throw new ConstructionException(strValue + " is NOT a valid Character");
                }
                returnVal = Character.valueOf(strValue.charAt(0));
            }
        }
        catch (Exception ex) {
            throw new ConstructionException("error while trying to create wrapper", ex);
        }
        if (returnVal == null) {
            throw new ConstructionException("can NOT create wrapper object for type=" + type + " with stringValue=" + strValue);
        }
        return returnVal;
    }
}

