/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.ConstructionException;
import ch.dvbern.oss.construct.xml.ClassFactory;
import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.PrimObjectFactory;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PrimParser
implements ElementParser {
    private static final Set<String> ALLOWED_ELEMENT_NAMES = Set.of("string", "int", "long", "short", "float", "double", "boolean", "char");

    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        Object value;
        String elementName = element.getNodeName();
        if (!ALLOWED_ELEMENT_NAMES.contains(elementName)) {
            throw new ElementParserException("PrimParser can not handle elements with the name=" + elementName);
        }
        Class<?> klass = null;
        try {
            klass = ClassFactory.getKlass(elementName);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("ClassFactory could NOT load Class with type=" + elementName, ex);
        }
        String strValue = element.getAttribute("value");
        if (strValue == null) {
            throw new ElementParserException("definition of argument NOT correct (value must NOT be null)");
        }
        try {
            value = PrimObjectFactory.getWrapper(elementName, strValue);
        }
        catch (ConstructionException ex) {
            throw new ElementParserException(ex);
        }
        return new ClassObjectPair(klass, value);
    }
}

