/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.oss.construct.xml.ResourceNotFoundException;
import ch.dvbern.oss.construct.xml.SafeDocumentBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RefParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!elementName.equals("ref")) {
            throw new ElementParserException("RefParser can not handle elements with the name=" + elementName);
        }
        String objectId = element.getAttribute("id");
        if (objectId == null || objectId.isEmpty()) {
            throw new ElementParserException("id of ref tag must be the name of a xml-file");
        }
        try {
            InputStream ins = factory.getResourceLocator().getResourceAsStream(objectId);
            DocumentBuilder builder = SafeDocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(ins);
            Element root = new Element(doc.getDocumentElement());
            return factory.getParser(root.getNodeName()).parse(root, factory);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new ElementParserException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException("no parser found", ex);
        }
        catch (ResourceNotFoundException ex) {
            throw new ElementParserException("ref parser: resource not foung", ex);
        }
    }
}

