/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ParserAlreadyRegisteredException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.oss.construct.xml.VariableAlreadyDefinedException;
import ch.dvbern.oss.construct.xml.VariableNotDefinedException;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ScopeParserFactory
extends ParserFactory {
    private final @NonNull ParserFactory factory;
    private final @NonNull Map<String, ClassObjectPair> varScope;

    public ScopeParserFactory(@NonNull ParserFactory factory) {
        this.factory = factory;
        this.varScope = new HashMap<String, ClassObjectPair>();
    }

    @Override
    public @NonNull ElementParser getParser(@NonNull String elementName) throws ParserNotRegisteredException {
        return this.factory.getParser(elementName);
    }

    @Override
    public void registerParser(@NonNull String elementName, @NonNull ElementParser parser) throws ParserAlreadyRegisteredException {
        this.factory.registerParser(elementName, parser);
    }

    public @NonNull ClassObjectPair getVariableCOP(@NonNull String varName) throws VariableNotDefinedException {
        ParserFactory parserFactory;
        ClassObjectPair value = this.varScope.get(varName);
        if (value == null && (parserFactory = this.factory) instanceof ScopeParserFactory) {
            ScopeParserFactory scopeParserFactory = (ScopeParserFactory)parserFactory;
            value = scopeParserFactory.getVariableCOP(varName);
        }
        if (value == null) {
            throw new VariableNotDefinedException("variable with name=" + varName + " not defined");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariableCOP(@NonNull String varName, @NonNull ClassObjectPair cop) throws VariableAlreadyDefinedException {
        Map<String, ClassObjectPair> map = this.varScope;
        synchronized (map) {
            if (this.varScope.get(varName) != null) {
                throw new VariableAlreadyDefinedException("A variable with name=" + varName + " is already defined");
            }
            this.varScope.put(varName, cop);
        }
    }
}

