/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.oss.construct.xml.ScopeParserFactory;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ScriptParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        List<Element> children = element.getChildElements();
        ClassObjectPair lastCOP = null;
        ScopeParserFactory scopeFactory = new ScopeParserFactory(factory);
        for (Element child : children) {
            String tagName = child.getNodeName();
            if (tagName.equals("return")) {
                Element objTag = child.getChildElements().get(0);
                try {
                    ClassObjectPair returnValue = scopeFactory.getParser(objTag.getNodeName()).parse(objTag, scopeFactory);
                    return returnValue;
                }
                catch (ParserNotRegisteredException ex) {
                    throw new ElementParserException(ex);
                }
            }
            try {
                lastCOP = scopeFactory.getParser(child.getNodeName()).parse(child, scopeFactory);
            }
            catch (ParserNotRegisteredException ex) {
                throw new ElementParserException(ex);
            }
        }
        if (lastCOP == null) {
            throw new ElementParserException("no child elements defined for element " + element.getNodeName());
        }
        return lastCOP;
    }
}

