/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SetFieldParser
implements ElementParser {
    @Override
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        Object newValue;
        Object myObject;
        ClassObjectPair cop;
        String fieldName = Objects.requireNonNull(element.getAttribute("name"), "name attribute is missing");
        List<Element> objectElChildren = element.getElementsByTagName("target");
        if (objectElChildren.size() != 1) {
            throw new ElementParserException("object must have exactly on child (construct or ref or cast...)");
        }
        Element objectElToParse = objectElChildren.get(0);
        Class<?> myClass = null;
        try {
            cop = factory.getParser(objectElToParse.getNodeName()).parse(objectElToParse, factory);
            myObject = cop.getObject();
            myClass = cop.getKlass();
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException(ex);
        }
        Element valueEl = element.getElementsByTagName("value").get(0);
        try {
            ClassObjectPair tmp = factory.getParser(valueEl.getNodeName()).parse(valueEl, factory);
            newValue = tmp.getObject();
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException(ex);
        }
        try {
            Field field = myClass.getField(fieldName);
            field.set(myObject, newValue);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new ElementParserException(ex);
        }
        return cop;
    }
}

