/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.construct.xml;

import ch.dvbern.oss.construct.ConstructionException;
import ch.dvbern.oss.construct.ObjectConstructor;
import ch.dvbern.oss.construct.xml.ClassLoaderResourceLocator;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.oss.construct.xml.ResourceChangeListener;
import ch.dvbern.oss.construct.xml.ResourceChangedEvent;
import ch.dvbern.oss.construct.xml.ResourceNotFoundException;
import ch.dvbern.oss.construct.xml.SafeDocumentBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLObjectConstructor
implements ObjectConstructor,
ResourceChangeListener {
    private final @NonNull Map<String, Object> cachedObjects = new HashMap<String, Object>();
    private final @NonNull ParserFactory factory;

    public XMLObjectConstructor() {
        this(new ParserFactory(new ClassLoaderResourceLocator()));
    }

    public XMLObjectConstructor(@NonNull ParserFactory factory) {
        this.factory = factory;
        factory.getResourceLocator().addResourceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Object construct(@NonNull String objectId, boolean newInstance) throws ConstructionException {
        Map<String, Object> map;
        Object obj = null;
        if (!newInstance) {
            map = this.cachedObjects;
            synchronized (map) {
                obj = this.cachedObjects.get(objectId);
            }
        }
        if (obj == null) {
            obj = this.parse(objectId, this.factory);
            map = this.cachedObjects;
            synchronized (map) {
                this.cachedObjects.put(objectId, obj);
            }
        }
        return obj;
    }

    private @NonNull Object parse(@NonNull String objectId, @NonNull ParserFactory parserFactory) throws ConstructionException {
        try {
            InputStream ins = parserFactory.getResourceLocator().getResourceAsStream(objectId);
            DocumentBuilder builder = SafeDocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(ins);
            Element root = new Element(doc.getDocumentElement());
            Object value = parserFactory.getParser(root.getNodeName()).parse(root, parserFactory).getObject();
            if (value == null) {
                throw new ConstructionException("Could not construct root, parser returned null");
            }
            return value;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new ConstructionException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ConstructionException("no parser found for root-element", ex);
        }
        catch (ElementParserException ex) {
            throw new ConstructionException("root-element could NOT have been parsed", ex);
        }
        catch (ResourceNotFoundException ex) {
            throw new ConstructionException("resource with id=" + objectId + " not found", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceChanged(@NonNull ResourceChangedEvent event) {
        String resource = event.getResourceName();
        Map<String, Object> map = this.cachedObjects;
        synchronized (map) {
            if (this.cachedObjects.get(resource) != null) {
                this.cachedObjects.remove(resource);
            }
        }
    }

    @Override
    public void resourceRemoved(@NonNull ResourceChangedEvent event) {
        this.resourceChanged(event);
    }
}

