/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.OsUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IOUtils {
    private static final Logger LOG = Logger.getLogger(IOUtils.class.getName());
    private static final Pattern ZIP_ENTRY_NAME_PTN = Pattern.compile("(/*)(.*?)(/*)");

    private IOUtils() {
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        if (srcDir == null || destDir == null) {
            throw new NullPointerException("invalid null argument");
        }
        if (srcDir.isDirectory()) {
            if (!destDir.exists() && !destDir.mkdirs()) {
                LOG.warning("Creating target directory: " + destDir.getAbsolutePath() + " unsucessful.");
            }
            String[] children = srcDir.list();
            Objects.requireNonNull(children);
            for (String element : children) {
                IOUtils.copyDirectory(new File(srcDir, element), new File(destDir, element));
            }
        } else {
            IOUtils.copyFile(srcDir, destDir);
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        if (src == null || dest == null) {
            throw new NullPointerException("invalid null argument");
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        IOUtils.copy(in, out);
        LOG.info("Copied " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new NullPointerException("invalid null argument");
        }
        try {
            int len;
            byte[] buf = new byte[8196];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            out.flush();
            if (in instanceof ZipInputStream) {
                ((ZipInputStream)in).closeEntry();
            } else {
                IOUtils.closeQuietly(in);
            }
            if (out instanceof ZipOutputStream) {
                ((ZipOutputStream)out).closeEntry();
            }
            IOUtils.closeQuietly(out);
        }
    }

    public static boolean deleteFileOrDirectory(File f) {
        if (f == null) {
            throw new NullPointerException("input file cannot be null");
        }
        if (f.isDirectory()) {
            File[] childs = f.listFiles();
            assert (childs != null);
            for (File child : childs) {
                IOUtils.deleteFileOrDirectory(child);
            }
        }
        return f.delete();
    }

    public static void closeQuietly(@Nullable Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error closing", e);
            }
        }
    }

    public static void closeQuietly(JarFile jf) {
        if (jf != null) {
            try {
                jf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean markExecutable(File f) {
        if (f == null) {
            throw new NullPointerException("input file cannot be null");
        }
        if (OsUtil.isOsWindows()) {
            return true;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"chmod", "+x", f.getAbsolutePath()});
            int code = p.waitFor();
            if (code != 0) {
                LOG.severe("chmod returned non-zero error code: " + code);
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            LOG.log(Level.INFO, "Current thread interrupted", e);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to invoke chmod, execution may fail", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, String entryName, File targetDir) throws IOException {
        if (zipFile == null) {
            throw new NullPointerException("zip file cannot be null");
        }
        if (entryName == null) {
            throw new NullPointerException("entry name cannot be null");
        }
        if (targetDir == null) {
            throw new NullPointerException("output file cannot be null");
        }
        Matcher m = ZIP_ENTRY_NAME_PTN.matcher(entryName);
        if (!m.matches()) {
            assert (false) : "Zip entry name regex is expected to match any string.";
            throw new IOException("Cannot parse entry name: " + entryName);
        }
        entryName = m.group(2);
        ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        boolean subDirectoryFound = false;
        boolean contentFound = false;
        FileOutputStream fos = null;
        try {
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                m = ZIP_ENTRY_NAME_PTN.matcher(entry.getName());
                if (!m.matches()) {
                    assert (false) : "Zip entry name regex is expected to match any string.";
                    throw new IOException("Failed to parse zip entry name: " + entry.getName());
                }
                String currentEntryName = m.group(2);
                if (!currentEntryName.startsWith(entryName)) continue;
                contentFound = true;
                if (entry.isDirectory()) {
                    new File(targetDir, currentEntryName).mkdirs();
                    subDirectoryFound = true;
                    continue;
                }
                File targetParent = targetDir.getParentFile();
                if (targetParent != null) {
                    targetParent.mkdirs();
                }
                if (currentEntryName.equals(entryName)) {
                    if (subDirectoryFound) {
                        LOG.warning("Inconsistent archive state: file entry with sub-directory, troubles ahead.");
                    }
                    fos = new FileOutputStream(new File(targetDir, entryName));
                    IOUtils.copy(zipStream, fos);
                    break;
                }
                fos = new FileOutputStream(new File(targetDir, currentEntryName));
                IOUtils.copy(zipStream, fos);
            }
            if (!contentFound) {
                throw new NoSuchElementException(entryName);
            }
        }
        finally {
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly(zipStream);
        }
    }

    public static boolean isParentDir(File parent, File child) throws IOException {
        if (parent == null || child == null) {
            throw new NullPointerException("Parent and child directory must be non-null");
        }
        String parentCPath = parent.getCanonicalPath();
        String childCPath = child.getCanonicalPath();
        if (OsUtil.isOsWindows()) {
            parentCPath = parentCPath.toLowerCase();
            childCPath = childCPath.toLowerCase();
        }
        return childCPath.startsWith(parentCPath);
    }

    public static byte[] readFully(@Nonnull InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static URL parseURL(@Nonnull String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Illegal URL: " + url, e);
        }
    }

    public static URL extendURL(@Nonnull URL url, @Nonnull String extension) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(extension);
        try {
            URL result = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + extension);
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot extend URL " + String.valueOf(url) + " with: " + extension, e);
        }
    }
}

