/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.OsUtil;
import ch.dvbern.lib.update.VersionUtil;
import ch.dvbern.lib.update.exception.ConfigurationException;
import ch.dvbern.lib.update.xjc.VersionConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibUpdateConfig {
    private static final Logger LOG = Logger.getLogger(LibUpdateConfig.class.getName());
    private static final String CONFIG_FILENAME = "libupdate.properties";
    public static final String SYSTEM_PROP_PREFIX = "sysprop.";
    private static final LibUpdateConfig INSTANCE = new LibUpdateConfig();
    private final Properties props = new Properties();
    private final File configFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private LibUpdateConfig() {
        File configFile;
        VersionConfig config;
        try {
            config = VersionUtil.loadVersionConfig();
        }
        catch (ConfigurationException e) {
            LOG.log(Level.SEVERE, "Failed to version config, assume empty config", e);
            this.configFile = null;
            return;
        }
        this.configFile = configFile = new File(new File(OsUtil.getUserHome(), config.getUserFolder()), CONFIG_FILENAME);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(configFile));
            this.props.load(bis);
        }
        catch (FileNotFoundException e) {
            LOG.fine("No config file accessible at " + configFile.getAbsolutePath() + ", assume empty config (" + e.getMessage() + ")");
            IOUtils.closeQuietly(bis);
            return;
        }
        catch (IOException e2) {
            LOG.log(Level.SEVERE, "Failed to read config file at " + configFile.getAbsolutePath() + " assume empty config", e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(bis);
            return;
        }
        IOUtils.closeQuietly(bis);
        LOG.fine("Loaded configuration from " + configFile.getAbsolutePath() + " (" + this.props.size() + " entries)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applySystemProperties() {
        Properties properties = this.props;
        synchronized (properties) {
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                assert (entry.getKey() instanceof String && entry.getValue() instanceof String) : "Compromised properties";
                String key = (String)entry.getKey();
                if (!key.startsWith(SYSTEM_PROP_PREFIX)) continue;
                String systemKey = key.substring(SYSTEM_PROP_PREFIX.length());
                if (systemKey.isEmpty()) {
                    LOG.warning("Ignoring empty system key");
                    continue;
                }
                System.setProperty(systemKey, (String)entry.getValue());
            }
        }
    }

    public static LibUpdateConfig getInstance() {
        return INSTANCE;
    }

    public String registerSystemProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be empty");
        }
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        String result = (String)this.props.setProperty(SYSTEM_PROP_PREFIX + key, value);
        this.persist();
        LOG.finer("Registered system property: [" + key + "=" + value + "] (previous value: '" + result + "'");
        return result;
    }

    public String unregisterSystemProperty(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be empty");
        }
        String result = (String)this.props.remove(SYSTEM_PROP_PREFIX + key);
        LOG.finer("Unregistered system property: " + key + " (was: " + result + ")");
        this.persist();
        return result;
    }

    private void persist() {
        if (this.configFile != null) {
            BufferedOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.configFile));
                this.props.store(bos, "Lib-update configuration file");
            }
            catch (IOException e) {
                try {
                    LOG.log(Level.SEVERE, "Failed to persist configuration file", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bos);
                    throw throwable;
                }
                IOUtils.closeQuietly(bos);
            }
            IOUtils.closeQuietly(bos);
        }
    }
}

