/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.VersionNumber;
import ch.dvbern.lib.update.exception.CauseType;
import ch.dvbern.lib.update.exception.UpdateFailureException;
import ch.dvbern.lib.update.xjc.Description;
import ch.dvbern.lib.update.xjc.LocalizedText;
import ch.dvbern.lib.update.xjc.Version;
import ch.dvbern.lib.update.xjc.VersionProperties;
import ch.dvbern.lib.update.xjc.VersionProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateVersion
implements Comparable<UpdateVersion> {
    private static final Pattern UNDERSCORES_PATTERN = Pattern.compile("_");
    @Nonnull
    private final VersionNumber versionNumber;
    @Nullable
    private final Version xmlDefinition;

    UpdateVersion(@Nonnull VersionNumber versionNumber, @Nullable Version xmlDefinition) {
        this.versionNumber = Objects.requireNonNull(versionNumber);
        this.xmlDefinition = xmlDefinition;
    }

    @Nonnull
    static UpdateVersion load(Version xmlDefinition) throws UpdateFailureException {
        Objects.requireNonNull(xmlDefinition, "XML definition cannot be null.");
        String version = xmlDefinition.getNumber();
        try {
            return new UpdateVersion(VersionNumber.parse(version), xmlDefinition);
        }
        catch (RuntimeException e) {
            throw new UpdateFailureException(CauseType.SERVER, "Unparsable version in update-site: " + version, e);
        }
    }

    @Nonnull
    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    @Nullable
    public String getProperty(@Nonnull String key) {
        Objects.requireNonNull(key, "Property key cannot be null.");
        Objects.requireNonNull(this.xmlDefinition, "UpdateVersion initialized incorrectly with xmlDefinition=null");
        VersionProperties properties = this.xmlDefinition.getProperties();
        if (properties == null) {
            return null;
        }
        for (VersionProperty property : properties.getProperties()) {
            if (!key.equals(property.getKey())) continue;
            return property.getValue();
        }
        return null;
    }

    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        Objects.requireNonNull(locale, "Locale cannot be null.");
        if (this.xmlDefinition == null) {
            return null;
        }
        Description description = this.xmlDefinition.getDescription();
        if (description == null) {
            return null;
        }
        List<LocalizedText> descriptionTexts = description.getTexts();
        if (descriptionTexts == null) {
            return null;
        }
        String language = UNDERSCORES_PATTERN.matcher(locale.toString()).replaceAll("-");
        String noLanguageKey = "";
        HashMap<String, LocalizedText> texts = new HashMap<String, LocalizedText>();
        for (LocalizedText lt : descriptionTexts) {
            String key = lt.getLang() == null ? "" : lt.getLang();
            texts.put(key, lt);
        }
        LocalizedText bestMatch = (LocalizedText)texts.get(language);
        if (bestMatch == null) {
            bestMatch = (LocalizedText)texts.get("");
        }
        return bestMatch != null ? bestMatch.getValue() : null;
    }

    @Nullable
    Version getXmlDefinition() {
        return this.xmlDefinition;
    }

    @Override
    public int compareTo(@Nonnull UpdateVersion o) {
        return this.versionNumber.compareTo(o.versionNumber);
    }

    @Nonnull
    public String toString() {
        return this.versionNumber.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UpdateVersion) {
            UpdateVersion that = (UpdateVersion)obj;
            return this.versionNumber.equals(that.versionNumber);
        }
        return false;
    }

    public int hashCode() {
        return this.versionNumber.hashCode();
    }
}

