/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.exception.ConfigurationException;
import ch.dvbern.lib.update.xjc.UpdateSite;
import ch.dvbern.lib.update.xjc.VersionConfig;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class VersionUtil {
    public static final String CLIENT_VERSION_FILE = "version.xml";

    private VersionUtil() {
    }

    @Deprecated
    public static String getLocalVersion() {
        try {
            return VersionUtil.loadVersionConfig().getVersion();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("Failed to read client version configuration file", e);
        }
    }

    public static VersionConfig loadVersionConfig() throws ConfigurationException {
        return VersionUtil.loadVersionConfig(new File(System.getProperty("user.dir")));
    }

    public static VersionConfig loadVersionConfig(File targetDir) throws ConfigurationException {
        VersionConfig versionConfig;
        if (targetDir == null) {
            throw new NullPointerException("target directory cannot be null");
        }
        File versionConfig2 = new File(targetDir, CLIENT_VERSION_FILE);
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(versionConfig2);
            bis = new BufferedInputStream(fis);
            versionConfig = VersionUtil.loadBinding(bis, VersionConfig.class);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ConfigurationException("Cannot found version config file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bis);
        IOUtils.closeQuietly(fis);
        return versionConfig;
    }

    public static UpdateSite loadUpdateSite(InputStream source) throws ConfigurationException {
        if (source == null) {
            throw new NullPointerException("input source cannot be null");
        }
        return VersionUtil.loadBinding(source, UpdateSite.class);
    }

    private static <T> T loadBinding(InputStream source, Class<T> target) throws ConfigurationException {
        Object binding;
        assert (source != null && target != null);
        InputStream schemaStream = null;
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{target});
            Unmarshaller um = ctx.createUnmarshaller();
            schemaStream = VersionUtil.class.getResourceAsStream("/xml/version.xsd");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(schemaStream));
            um.setSchema(schema);
            binding = um.unmarshal((Source)new StreamSource(source), target).getValue();
        }
        catch (JAXBException | SAXException e) {
            try {
                throw new ConfigurationException("Failed to parse config file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(schemaStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(schemaStream);
        return (T)binding;
    }

    public static boolean isBlank(String value) {
        return value == null || value.isEmpty();
    }
}

