/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.elevate.cocoa;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.OsUtil;
import ch.dvbern.lib.update.elevate.ElevatedCommandBuilder;
import ch.dvbern.lib.update.elevate.ElevationFailedException;
import ch.dvbern.lib.update.elevate.PriviligesElevatorBase;
import ch.dvbern.lib.update.elevate.cocoa.CocoaSudoCommandBuilder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class CocoaSudoPrivilegesElevator
extends PriviligesElevatorBase {
    private static final Logger LOG = Logger.getLogger(CocoaSudoPrivilegesElevator.class.getName());
    private static final String PROGRAM_RESOURCE_NAME = "cocoasudo";

    @Override
    public boolean supportsCurrentSystem() {
        return OsUtil.isOsMac();
    }

    @Override
    public boolean processExitCode(int code) throws ElevationFailedException {
        if (code != 0) {
            throw new ElevationFailedException("Non-zero error code returned by elevation utility: " + code);
        }
        return true;
    }

    @Override
    protected ElevatedCommandBuilder elevatedCommandBuilder(String prompt, String icon) {
        try {
            File helperProgram = this.extractHelperResource(PROGRAM_RESOURCE_NAME);
            IOUtils.markExecutable(helperProgram);
            return new CocoaSudoCommandBuilder(prompt, icon, helperProgram);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to extract helper program", e);
        }
    }
}

