/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.elevate.uac;

import ch.dvbern.lib.update.OsUtil;
import ch.dvbern.lib.update.elevate.ElevatedCommandBuilder;
import ch.dvbern.lib.update.elevate.ElevationFailedException;
import ch.dvbern.lib.update.elevate.PowershellElevatedCommandBuilder;
import ch.dvbern.lib.update.elevate.PriviligesElevatorBase;
import java.util.logging.Logger;

public class WindowsUACPrivilegesElevator
extends PriviligesElevatorBase {
    private static final String PROGRAM_RESOURCE_NAME = "elevate.exe";
    private static final Logger LOG = Logger.getLogger(WindowsUACPrivilegesElevator.class.getName());

    @Override
    public boolean supportsCurrentSystem() {
        return OsUtil.isOsWindows();
    }

    @Override
    public boolean processExitCode(int code) throws ElevationFailedException {
        if (code != 0) {
            throw new ElevationFailedException("Non-zero error code returned by elevation utility: " + code);
        }
        return true;
    }

    @Override
    protected ElevatedCommandBuilder elevatedCommandBuilder(String prompt, String icon) {
        return new PowershellElevatedCommandBuilder();
    }
}

