/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.signatures;

import ch.dvbern.lib.cryptutil.SignatureFailedException;
import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.SecureDownloader;
import ch.dvbern.lib.update.exception.CauseType;
import ch.dvbern.lib.update.exception.UpdateFailureException;
import ch.dvbern.lib.update.signatures.SignMethod;
import ch.dvbern.lib.update.signatures.SignatureVerifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class MultiMethodSignatureVerifier
implements SignatureVerifier {
    private static final Pattern SIGNATURE_FILE_INFIX_VALID_CHARS = Pattern.compile("^\\w*$");
    @Nonnull
    private final PublicKey publicKey;
    @Nonnull
    private final List<SignMethod> signMethods;
    @Nonnull
    private final String signatureFileInfix;

    public MultiMethodSignatureVerifier(@Nonnull PublicKey publicKey, @Nonnull List<SignMethod> signMethods, @Nonnull String signatureFileInfix) {
        this.publicKey = Objects.requireNonNull(publicKey);
        this.signMethods = new ArrayList<SignMethod>(signMethods);
        if (signMethods.isEmpty()) {
            throw new IllegalArgumentException("signMethods may not be empty!");
        }
        if (signMethods.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("all signMethods must be != null");
        }
        this.signatureFileInfix = Objects.requireNonNull(signatureFileInfix);
        if (!SIGNATURE_FILE_INFIX_VALID_CHARS.matcher(signatureFileInfix).matches()) {
            throw new IllegalArgumentException("signatureFileInfix may only contain word characters");
        }
    }

    @Nonnull
    public List<SignMethod> getSignMethods() {
        return this.signMethods;
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void verify(@Nonnull URL baseFileURL, @Nonnull byte[] toVerify, @Nonnull SecureDownloader secureDownloader) throws UpdateFailureException {
        for (SignMethod signMethod : this.signMethods) {
            try {
                byte[] referenceSignature = this.readReferenceSignature(IOUtils.extendURL(baseFileURL, this.signatureFileInfix), signMethod, secureDownloader);
                boolean valid = signMethod.isSignatureValid(referenceSignature, this.publicKey, new ByteArrayInputStream(toVerify));
                if (valid) continue;
                throw new UpdateFailureException(CauseType.SIGNATURE, "Invalid file signature: " + String.valueOf(baseFileURL) + ", algo: " + String.valueOf((Object)signMethod));
            }
            catch (SignatureFailedException e) {
                throw new UpdateFailureException(CauseType.SIGNATURE, "Signature defect: " + String.valueOf(baseFileURL), e);
            }
            catch (IOException e) {
                throw new UpdateFailureException(CauseType.UNKNOWN, "Could not download signature file for: " + String.valueOf(baseFileURL), e);
            }
        }
    }

    private byte[] readReferenceSignature(@Nonnull URL absoluteURL, @Nonnull SignMethod signMethod, @Nonnull SecureDownloader secureDownloader) throws IOException {
        try (InputStream signatureStream = secureDownloader.downloadSecure(absoluteURL, signMethod);){
            byte[] signature;
            byte[] byArray = signature = IOUtils.readFully(signatureStream);
            return byArray;
        }
    }
}

