/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.pdfforms;

import ch.dvbern.lib.pdfforms.pagenumbering.NOPPageNumberingAlgo;
import ch.dvbern.lib.pdfforms.pagenumbering.PageNumberingAlgo;
import ch.dvbern.lib.pdfforms.processing.ProcessorOperation;
import java.net.URL;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FormattingParams {
    public static final PageNumberingAlgo DEFAULT_PAGE_NUMBERING_ALGO = new NOPPageNumberingAlgo();
    private final @NonNull URL templateURL;
    private final @NonNull Locale formattingLocale;
    private final @NonNull NumberFormat defaultDecimalFormat;
    private final @NonNull NumberFormat defaultIntegerFormat;
    private final @NonNull DateTimeFormatter defaultDateFormat;
    private final @NonNull DateTimeFormatter defaultDateTimeFormat;
    private final @NonNull PageNumberingAlgo pageNumberingAlgo;
    private final @NonNull String watermark;
    private final @NonNull String outlineText;
    private final @NonNull List<ProcessorOperation> postProcessors;

    private FormattingParams(@NonNull Builder builder) {
        this.templateURL = Objects.requireNonNull(builder.templateURL);
        this.formattingLocale = Objects.requireNonNull(builder.formattingLocale);
        this.defaultDecimalFormat = Objects.requireNonNull(builder.defaultDecimalFormat);
        this.defaultIntegerFormat = Objects.requireNonNull(builder.defaultIntegerFormat);
        this.defaultDateFormat = Objects.requireNonNull(builder.defaultDateFormat);
        this.defaultDateTimeFormat = Objects.requireNonNull(builder.defaultDateTimeFormat);
        this.pageNumberingAlgo = Objects.requireNonNull(builder.pageNumberingAlgo);
        this.watermark = Objects.requireNonNull(builder.watermark);
        this.outlineText = Objects.requireNonNull(builder.outlineText);
        this.postProcessors = Collections.unmodifiableList(Objects.requireNonNull(builder.postProcessors));
    }

    public static Builder newBuilder(@NonNull URL templateURL, @NonNull Locale formattingLocale) {
        Builder builder = new Builder(Objects.requireNonNull(templateURL), Objects.requireNonNull(formattingLocale), DEFAULT_PAGE_NUMBERING_ALGO, NumberFormat.getNumberInstance(formattingLocale), NumberFormat.getIntegerInstance(formattingLocale), DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(formattingLocale), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(formattingLocale), "", "", Collections.emptyList());
        return builder;
    }

    public static @NonNull Builder newBuilder(@NonNull FormattingParams copy) {
        Objects.requireNonNull(copy);
        Builder builder = new Builder(copy.getTemplateURL(), copy.getFormattingLocale(), copy.getPageNumberingAlgo(), copy.getDefaultDecimalFormat(), copy.getDefaultIntegerFormat(), copy.getDefaultDateFormat(), copy.getDefaultDateTimeFormat(), copy.getWatermark(), copy.getOutlineText(), new ArrayList<ProcessorOperation>(copy.getPostProcessors()));
        return builder;
    }

    public @NonNull Builder toBuilder() {
        return FormattingParams.newBuilder(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.templateURL).append((Object)this.formattingLocale).build();
    }

    public @NonNull URL getTemplateURL() {
        return this.templateURL;
    }

    public @NonNull Locale getFormattingLocale() {
        return this.formattingLocale;
    }

    public @NonNull PageNumberingAlgo getPageNumberingAlgo() {
        return this.pageNumberingAlgo;
    }

    public @NonNull NumberFormat getDefaultDecimalFormat() {
        return this.defaultDecimalFormat;
    }

    public @NonNull NumberFormat getDefaultIntegerFormat() {
        return this.defaultIntegerFormat;
    }

    public @NonNull DateTimeFormatter getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public @NonNull DateTimeFormatter getDefaultDateTimeFormat() {
        return this.defaultDateTimeFormat;
    }

    public @NonNull String getWatermark() {
        return this.watermark;
    }

    public @NonNull String getOutlineText() {
        return this.outlineText;
    }

    public @NonNull List<ProcessorOperation> getPostProcessors() {
        return this.postProcessors;
    }

    public static final class Builder {
        private @NonNull URL templateURL;
        private @NonNull Locale formattingLocale;
        private @NonNull PageNumberingAlgo pageNumberingAlgo;
        private @NonNull NumberFormat defaultDecimalFormat;
        private @NonNull NumberFormat defaultIntegerFormat;
        private @NonNull DateTimeFormatter defaultDateFormat;
        private @NonNull DateTimeFormatter defaultDateTimeFormat;
        private @NonNull String watermark = "";
        private @NonNull String outlineText;
        private @NonNull List<ProcessorOperation> postProcessors;

        private Builder(@NonNull URL templateURL, @NonNull Locale formattingLocale, @NonNull PageNumberingAlgo pageNumberingAlgo, @NonNull NumberFormat defaultDecimalFormat, @NonNull NumberFormat defaultIntegerFormat, @NonNull DateTimeFormatter defaultDateFormat, @NonNull DateTimeFormatter defaultDateTimeFormat, @NonNull String watermark, @NonNull String outlineText, @NonNull List<ProcessorOperation> postProcessors) {
            this.templateURL = templateURL;
            this.formattingLocale = formattingLocale;
            this.pageNumberingAlgo = pageNumberingAlgo;
            this.defaultDecimalFormat = defaultDecimalFormat;
            this.defaultIntegerFormat = defaultIntegerFormat;
            this.defaultDateFormat = defaultDateFormat;
            this.defaultDateTimeFormat = defaultDateTimeFormat;
            this.watermark = watermark;
            this.outlineText = outlineText;
            this.postProcessors = postProcessors;
        }

        public @NonNull Builder withTemplateURL(@NonNull URL val) {
            this.templateURL = val;
            return this;
        }

        public @NonNull Builder withFormattingLocale(@NonNull Locale val) {
            this.formattingLocale = val;
            return this;
        }

        public @NonNull Builder withDefaultDecimalFormat(@NonNull NumberFormat val) {
            this.defaultDecimalFormat = val;
            return this;
        }

        public @NonNull Builder withDefaultIntegerFormat(@NonNull NumberFormat val) {
            this.defaultIntegerFormat = val;
            return this;
        }

        public @NonNull Builder withDefaultDateFormat(@NonNull DateTimeFormatter val) {
            this.defaultDateFormat = val;
            return this;
        }

        public @NonNull Builder withDefaultDateTimeFormat(@NonNull DateTimeFormatter val) {
            this.defaultDateTimeFormat = val;
            return this;
        }

        public @NonNull Builder withPageNumberingAlgo(@NonNull PageNumberingAlgo val) {
            this.pageNumberingAlgo = val;
            return this;
        }

        public @NonNull Builder withWatermark(@NonNull String val) {
            this.watermark = val;
            return this;
        }

        public @NonNull Builder withOutlineText(@NonNull String val) {
            this.outlineText = val;
            return this;
        }

        public @NonNull Builder withPostProcessors(@NonNull List<ProcessorOperation> val) {
            this.postProcessors = val;
            return this;
        }

        public Builder withPostProcessor(@NonNull ProcessorOperation operation) {
            this.postProcessors.add(operation);
            return this;
        }

        public @NonNull FormattingParams build() {
            return new FormattingParams(this);
        }
    }
}

