/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.pdfforms;

import ch.dvbern.lib.pdfforms.FormattingParams;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Page {
    private static final String PDF_NEWLINE_CHAR = "\r";
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\n", 16);
    private final @NonNull Set<URI> embeddableFontFiles = new HashSet<URI>();
    private final @NonNull Map<String, String> values = new HashMap<String, String>();
    private final @NonNull FormattingParams formattingParams;
    public static final String EMPTY_VALUE = "";

    public Page(@NonNull FormattingParams formattingParams) {
        this.formattingParams = Objects.requireNonNull(formattingParams);
    }

    public @NonNull FormattingParams getFormattingParams() {
        return this.formattingParams;
    }

    public void embedFontFile(@NonNull URI fontURI) {
        this.embeddableFontFiles.add(Objects.requireNonNull(fontURI));
    }

    public void embedFontFiles(@NonNull Collection<@NonNull URI> fontURIs) {
        this.requireElemsNotNull(fontURIs);
        this.embeddableFontFiles.addAll(fontURIs);
    }

    private void requireElemsNotNull(@NonNull Collection<?> collection) {
        if (collection.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("entries must not be null");
        }
    }

    public Set<URI> getEmbeddableFontFiles() {
        return Collections.unmodifiableSet(this.embeddableFontFiles);
    }

    public void putField(@NonNull String fieldId, @Nullable String value) {
        this.values.put(fieldId, value == null ? EMPTY_VALUE : NEWLINE_PATTERN.matcher(value).replaceAll(Matcher.quoteReplacement(PDF_NEWLINE_CHAR)));
    }

    public void putField(@NonNull String fieldId, @Nullable LocalDate date) {
        this.putField(fieldId, date == null ? null : date.format(this.formattingParams.getDefaultDateFormat()));
    }

    public void putField(@NonNull String fieldId, @Nullable LocalDate date, @NonNull DateTimeFormatter formatter) {
        this.putField(fieldId, date == null ? null : date.format(formatter));
    }

    public void putField(@NonNull String fieldId, @Nullable LocalDateTime dateTime) {
        this.putField(fieldId, dateTime == null ? null : dateTime.format(this.formattingParams.getDefaultDateTimeFormat()));
    }

    public void putField(@NonNull String fieldId, @Nullable LocalDateTime dateTime, @NonNull DateTimeFormatter formatter) {
        this.putField(fieldId, dateTime == null ? null : dateTime.format(formatter));
    }

    public void putField(@NonNull String fieldId, @Nullable BigDecimal bd) {
        this.putField(fieldId, bd, this.formattingParams.getDefaultDecimalFormat());
    }

    public void putField(@NonNull String fieldId, @Nullable BigDecimal bd, @NonNull NumberFormat numberFormat) {
        this.putField(fieldId, bd == null ? null : numberFormat.format(bd));
    }

    public void putField(@NonNull String fieldId, @Nullable BigInteger bi) {
        this.putField(fieldId, bi, this.formattingParams.getDefaultIntegerFormat());
    }

    public void putField(@NonNull String fieldId, @Nullable BigInteger bi, @NonNull NumberFormat numberFormat) {
        this.putField(fieldId, bi == null ? null : numberFormat.format(bi));
    }

    public void putFieldStringify(@NonNull String fieldId, @Nullable Object value) {
        if (value == null) {
            this.putField(fieldId, (String)null);
        } else {
            this.putField(fieldId, value, String::valueOf);
        }
    }

    public <T> void putField(@NonNull String fieldId, @Nullable T value, @NonNull Function<@Nullable T, @Nullable String> valueFormatter) {
        String resolvedValue = valueFormatter.apply(value);
        this.putField(fieldId, resolvedValue);
    }

    public @NonNull Map<String, String> getFieldValues() {
        return Collections.unmodifiableMap(this.values);
    }
}

