/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.pdfforms.processing;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ImageData {
    private final int imageWidth;
    private final int imageHeight;
    private final int imageColorComponents;
    private final int imageBitsPerComponent;
    private final @NonNull byte[] imageBytes;

    public ImageData(int imageWidth, int imageHeight, int imageColorComponents, int imageBitsPerComponent, byte[] imageBytes) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)imageWidth);
        this.imageWidth = imageWidth;
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)imageHeight);
        this.imageHeight = imageHeight;
        Validate.inclusiveBetween((long)1L, (long)4L, (long)imageColorComponents);
        this.imageColorComponents = imageColorComponents;
        Validate.inclusiveBetween((long)1L, (long)32L, (long)imageBitsPerComponent);
        this.imageBitsPerComponent = imageBitsPerComponent;
        this.imageBytes = Objects.requireNonNull(imageBytes);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageColorComponents() {
        return this.imageColorComponents;
    }

    public int getImageBitsPerComponent() {
        return this.imageBitsPerComponent;
    }

    public @NonNull byte[] getImageBytes() {
        return this.imageBytes;
    }
}

